/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: DumpParserHP.java,v 1.5 2005/02/16 22:19:54 qiyanli Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
/*
 * DumpParser - IBM, March 2001
 */

package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaException;
import org.eclipse.hyades.collection.threadanalyzer.Thd;


public class DumpParserHP extends DumpParser
{

   public DumpParserHP( )
   {
   }

   public void parse( DumpData d )
   throws Exception
   {
      try
      {
         if( _r.ready() )
         {
          //  String s = _r.readLine(); // version              
            getThreadData( d );
			//dipak;
			//get rest of file
			while( getLine(d) != null ) {}
         }
      }
      catch( Exception e )
      {
		 logErr( TAUtils.getNLSValue("ta.errmsg.ExceptionWhileParsing", "exception while parsing line") + ": " + _lineNo + " -- " + _dumpInName );
         throw new TaException(""+_lineNo, e);
      }

   }


   private void getThreadData( DumpData d ) throws Exception
   {      
	  // Read up thru 'Full thread dump'
      readToDump();

      String line = null;
      char firstChar = 0;

	  // Consume 2 lines from buffer and store them in DumpData
      line = getLine( d );
      line = getLine( d ); 

      Thd thd = null;

	  // Do while buffer not empty
      while( _r.ready() )
      {
         if(line.length() > 0 )
            firstChar = line.charAt( 0 );
         else
            firstChar = 0;

		 // if firstChar is a quote then let's parse a thread info block
		 //dipak
		if( line.indexOf("FOUND A JAVA LEVEL DEADLOCK:") != -1 )
			break;
         else if( firstChar == '\"' ) // new thread
         {
//			System.err.println( "line = " + line );
//			System.err.println( "Starting new Thread" );

            int idx1 = line.indexOf( '\"' );         // position of opening quote
            int idx2 = line.indexOf( '\"', idx1+1 ); // position of closing quote

            String thdNm = line.substring( idx1+1, idx2 );
            StringTokenizer st = new StringTokenizer(line.substring(idx2+1));
            String line2 = st.nextToken();
			if( line2.equals("daemon") )
				line2 = st.nextToken();
            String priority = line2.substring(5);
            line2 = st.nextToken();
            String threadId = line2.substring(4);
            line2 = st.nextToken();
            line2 = st.nextToken();
            line2 = st.nextToken();
			String state = line2;
			while( st.hasMoreTokens() )
				state = state + " " + st.nextToken(); 
            thd = d.addThd( thdNm, threadId, state, priority );

//			System.err.println( "Done with new Thread" );

         }
         else if( firstChar == '\t' )  // thread stack entry // ccc if part
         {
            //String line2 = line.substring( 4 );

            // ccc above line originally there     
            StringTokenizer st = new StringTokenizer(line);
            String line2 = new String(st.nextToken());
            line2 = st.nextToken();

//			System.err.println( "line2 = " + line2 );
			if( line2.equals("waiting") || line2.equals("locked") ) {
				line = getLine( d ); 
				continue;
			}

//			System.err.println( "Starting new Stack Entry" );

            if(st.hasMoreTokens())
            {
               line2 = line2 + " " + st.nextToken();
            }

            boolean isNative = false;
            String moduleName = null;
            String lineno = null;
            int idx1 = line2.indexOf( "(Native Method)" );
            if( idx1 > 0 )
            {
               isNative = true;

               line2 = line2.substring( 0, idx1 );
            }
            else
            {
               idx1 = line2.indexOf( "(" );
               ++idx1;
               String moduleInfo = line2.substring( idx1 );
               line2 = line2.substring( 0, idx1-1 );

               int idx2 = moduleInfo.indexOf( ':' );
               if( idx2 > 0 )
               {
                  lineno = moduleInfo.substring( idx2+1, moduleInfo.indexOf( ')', idx2) ); //originally was idx2-1
                  moduleName = moduleInfo.substring( 0, idx2 ); 
               }
               else
               {
                  idx2 = moduleInfo.indexOf( ')' ); //originally '(' instead of ')'
                  moduleName = moduleInfo.substring( 0, idx2 );
               }
            }
            String method = line2.substring( line2.lastIndexOf( '.' ) + 1 );
            String pkg = line2.substring( 0, line2.lastIndexOf( '.' ) );
            int iLineNo = -1;
            if(lineno != null)
            {
               iLineNo = Integer.parseInt( lineno );
            }
            StkEntry se = new StkEntry( method, pkg, moduleName, iLineNo, isNative );
            //     System.out.println( "  -- " + pkg + " . " + method + " - "  +  " - " + moduleName + " - " + lineno + " - " + isNative );
            thd.addStackEntry( se );


//			System.err.println( "done adding new Stack Entry" );
         }

         line = getLine( d ); 

      }
   }

   private void readToDump()
   {
      /* removed dependency on jakarta re - d111401
      RE ftdRE = null;
      try
      {

         ftdRE = new RE( "Full thread dump.*$" ); 
      }
      catch( Exception e )
      {
         logErr( "internal error: RE(1)" );
         System.exit( -1 );
         
      }
      */


	  /* Consumes buffer all the way up through 'Full thread dump'.  
         Next line read from file will be the one after 'Full thread dump'.
	  */

      int lineNo = 0;
      int matchAt = -1;
      try
      {

         while( _r.ready() )
         {
            String str1 = _r.readLine();
            ++lineNo;
            // d111401 if( ftdRE.match( str1 ) )
            if( str1.indexOf( "Full thread dump" ) > -1 )
            {
               matchAt = lineNo;
               break;
            }
         }
         if( matchAt > -1 )
         {
            _r.close();
            _r = new BufferedReader( new FileReader( _dumpInName ) );
            lineNo = 0;
            String str1 = null;
            while( lineNo < matchAt )
            {
               str1 = _r.readLine();
               ++lineNo;
            }
         }

      }
      catch( IOException ioe )
      {
         logErr( TAUtils.getNLSValue("ta.errmsg.ErrReading", "error reading") + " " + "stderr");
         System.exit( -1 );
      }

   }


}


