/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConnectionHandlerImpl.java,v 1.4 2005/02/16 22:19:54 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.internal.collection.framework;

import java.net.Socket;
import org.eclipse.hyades.execution.security.*;

/**
 * @author dnsmith
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ConnectionHandlerImpl implements IConnectionHandler {
	
	
	public void connectionAccepted(Socket s) {

		ClientHandlerImpl cHandler = new ClientHandlerImpl(s);
		
		/* Create client in native code, passing it the handler */
		int result;
		
		result = createClient(cHandler);	
	}
	
	private int createClient(ClientHandlerImpl cHandler) {
		try {
			return createClient0(cHandler);
		}
		catch (UnsatisfiedLinkError le) {
			return -1;
		}
	}
	/**
	  * Native method to create a client structure and client message processing native thread.
	  * @param cHandler  ClientHandlerImpl  - client handler impl object to be used by the native code
	  * @return int  - result (0 if success, -1 if error occurs)
	  */
	 private native int createClient0(ClientHandlerImpl cHandler);
		
}