/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: SecureFileServerParametersExtendedImpl.java,v 1.1 2005/05/05 20:04:37 samwai Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.collection.framework;

import org.eclipse.hyades.execution.security.IConnectionHandler;
import org.eclipse.hyades.execution.security.ISecureServerParameters;

/**
 * An implementation of secure file server parameters to be used with the
 * extended file transfer service, the implementation returns an adapted file
 * connection handler implementation that adapts an incoming socket connection
 * into a channel that the implementation is expecting.
 * 
 * The secure file server parameters implementation uses an adapter because SSL
 * and java.nio channels are not very integrated in Java 1.4, although Java 5
 * improves in this area
 * 
 * @author Scott E. Schneider
 */
class SecureFileServerParametersExtendedImpl extends SecureServer implements ISecureServerParameters {

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.hyades.execution.security.ISecureServerParameters#getConnectionHandler()
     */
    public IConnectionHandler getConnectionHandler() {
        return new FileConnectionHandlerExtended.Adapter(); // socket to channel
    }

}