/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: SecureFileServerParametersImpl.java,v 1.3 2005/05/08 20:16:19 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.collection.framework;

import org.eclipse.hyades.execution.security.IConnectionHandler;

/**
 * This is now a bridge class that forwards the get connection handler method on
 * to the appropriate concrete instance, the former class that was named as this
 * class is now marked as legacy.
 * 
 * @author Scott E. Schneider
 */
public class SecureFileServerParametersImpl extends SecureServer {

    /* A file connection handler object */
    private IConnectionHandler fileConnectionHandler;

    public IConnectionHandler getConnectionHandler() {

        if (fileConnectionHandler == null)
            fileConnectionHandler = new FileConnectionHandlerImpl();

        return fileConnectionHandler;
    }
}

