/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: SetConfig.java,v 1.5 2005/05/06 20:55:28 dnsmith Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.logging.parsers;

import java.util.Hashtable;

import org.eclipse.hyades.internal.config.generator.Application;
import org.eclipse.hyades.internal.config.generator.HashUtility;
import org.eclipse.hyades.internal.config.generator.Option;
import org.eclipse.hyades.internal.config.generator.Parameter;
import org.eclipse.hyades.internal.config.generator.PluginConfig;
import org.eclipse.hyades.internal.config.generator.SetConfigSkeleton;
import org.eclipse.hyades.internal.config.generator.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetConfig extends SetConfigSkeleton {
	public static String TAG = "org.eclipse.hyades.logging.parsers";

	public SetConfig() {
		super(TAG);
	}

	public void init(Hashtable hash) {	
		String home = HashUtility.getValue(hash, "RASERVER_HOME");
		setFileName(home + sr + "plugins" + sr + TAG + sr + "config" + sr + "pluginconfig.xml");
	}

	public void askUser() {
		// This method is not being used
	}

	public void generateConfiguration() {
		Document doc;
		Element holder;
		Element pConfig;

		Element agent;
		Element app;
		Element option;
		Element param;
		Element var;

		//
		// Standard initializer 
		//
		doc = configFile.getDoc();
		if(doc == null) {
			return;
		}

		pConfig = doc.createElement(PluginConfig.TAG);
		holder = configFile.getHolder();
		holder.appendChild(pConfig);

		//
		// Plugin specific information
		//
		app = doc.createElement(Application.TAG);
		Application.setConfiguration(app, "default");
		Application.setExecutable(app, "RemoteLogParserLoader");
		Application.setLocation(app, "%SYS_TEMP_DIR%"); // Bug 62317
		Application.setPath(app, "%JAVA_PATH%");
		pConfig.appendChild(app);

		// Bug 73902
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "GLA_HOME");
		Variable.setPosition(var, "replace");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + TAG);
		app.appendChild(var);

		// Bug 62317 begins
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "GLA_CONFIG_PATH");
		Variable.setPosition(var, "replace");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + TAG + sr + "config");
		app.appendChild(var);
		// Bug 62317 ends

		/* Bugzilla 93954 start
		 * Changing the setting of the classpath to replace the Agent 
		 * Controller global classpath instead of just prepending to it so 
		 * RemoteLogParserLoader is not effected by any other external jar on the
		 * global classpath, such as runtime.jar.  Therefore need to include all
		 * required jars from RASERVER_HOME/lib
		 */
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "replace");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.logging.parsers" + sr + "lib" + sr + "hgla.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.logging.parsers" + sr + "lib" + sr + "hglaconfig.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "plugins" + sr + "org.eclipse.hyades.logging.parsers" + sr + "lib" + sr + "hparse.jar");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "commons-logging.jar");
		Variable.setPosition(var, "append");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hexr.jar");
		Variable.setPosition(var, "append");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hlcommons.jar");
		Variable.setPosition(var, "append");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hlcore.jar");
		Variable.setPosition(var, "append");
		app.appendChild(var);

		/* Bug 58037 begins */
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hlcbe101.jar");
		Variable.setPosition(var, "append");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "ecore.jar");
		Variable.setPosition(var, "append");
		app.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");
		Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "common.jar");
		Variable.setPosition(var, "append");
		app.appendChild(var);
		/* Bugzilla 93954 end */
		
		param = doc.createElement(Parameter.TAG);
		Parameter.setPosition(param, "prepend");
		Parameter.setValue(param, "org.eclipse.hyades.logging.parsers.RemoteLogParserLoader");
		app.appendChild(param);

		// Bug 73902
		param = doc.createElement(Parameter.TAG);
		Parameter.setPosition(param, "prepend");
		Parameter.setValue(param, "-DGLA_HOME=&quot;%GLA_HOME%&quot;");
		app.appendChild(param);

		// Bug 60191
		param = doc.createElement(Parameter.TAG);
		Parameter.setPosition(param, "prepend");
		Parameter.setValue(param, "-Djava.version=1.4");
		app.appendChild(param);

		// Bug 62317 begins
		param = doc.createElement(Parameter.TAG);
		Parameter.setPosition(param, "append");
		Parameter.setValue(param, "&quot;config_path=%GLA_CONFIG_PATH%&quot;");
		app.appendChild(param);
		// Bug 62317 ends

		//
		// The following can be reused for other plugins
		//
		option = doc.createElement(Option.TAG);
		Option.setName(option, TAG);
		Option.setType(option, "version");
		Option.setValue(option, getString("Config.Plugin.Version"));
		pConfig.appendChild(option);

		configFile.saveToFile();
	}

	public void printHelp() {
	}

	public void printExamples() {
	}
}
