/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenStatisticalViewerAction.java,v 1.5 2005/03/23 21:05:47 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.actions.internal;


import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.StatisticalViewer;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.*;

/**
 * Insert the type's description here.
 * Creation date: (09/28/2000 12:00:37 PM)
 * @author: Administrator
 */
public class OpenStatisticalViewerAction
	extends OpenTraceViewAction
{		
	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 */
	public OpenStatisticalViewerAction() {
		super("");
	}
	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 */
	public OpenStatisticalViewerAction(String label) {
		super(label);
	}
	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 * @param image com.ibm.jface.parts.IImage
	 */
	public OpenStatisticalViewerAction(
		String label,
		ImageDescriptor image) {
		super(label, image);
	}

	/*
	 * 
	 */
	protected void openView() {
		IWorkbenchWindow window =
			TraceUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();

		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();
			
			StatisticalViewer view =
				(StatisticalViewer) persp.showView(
					"org.eclipse.hyades.trace.views.adapter.internal.StatisticalViewer");

			if (view != null) {
				view.addViewPage(getMofObject());

			}

		} catch (Exception e) {
			String msg =
			TraceUIPlugin.getString("STR_OPEN_STATISTIC_ERROR_");

			Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					e.toString(),
					null);

			ErrorDialog.openError(window.getShell(), msg, "",
			// no special message
			err);

			e.printStackTrace();
		}
	}

	/*
	 * 
	 */
	public void run() {
		openView();
	}

	/*
	 * 
	 */
	public void run(IAction action) {
		run();
	}		
}
