/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CoverageStatisticViewer.java,v 1.8 2005/03/18 20:11:48 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;


public class CoverageStatisticViewer extends MultiLevelStatisticMethodViewer {
	
	protected static final String _title =
		TraceUIPlugin.getString("STR_COVERAGE_ST_TITLE");

	public CoverageStatisticViewer() {
		super();
	}

	/**
	 * create a coverage page
	 */
	public TraceViewerPage createPage(EObject mofObject) {
		return new CoverageStatisticPage(mofObject, this);
	}

	/**
	 * return the view title
	 */
	public String getViewTitle() {
		return _title;
	}
//
//	public String[] getTypeDescriptions() {
//		String[] typeDescriptions = new String[2];
//		typeDescriptions[0] = "org.eclipse.hyades.profilingType.execution";		
//		typeDescriptions[1] = "org.eclipse.hyades.profilingType.methodCoverage";
//		return typeDescriptions;
//	}
}
