/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionStatisticPage2.java,v 1.4 2005/02/16 22:24:03 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.trace.ui.*;

import org.eclipse.swt.widgets.*;
import org.eclipse.jface.action.*;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.trace.views.internal.ExecutionStatisticView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;

public class ExecutionStatisticPage2 extends MultiLevelStatisticMethodPage {

	public ExecutionStatisticPage2(EObject mofObject, TraceViewer _viewer) {
		super(mofObject, _viewer);
	}

	/**
	 * display the coverage data by creating an instance
	 * of the CoverageStatistic class
	 */
	protected MultiLevelStatisticView displayData(Composite parent) {
		// Let's save the level and load it in the new instance
		ExecutionStatisticView view = new ExecutionStatisticView(parent, this);
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
				parent,
				TraceUIPlugin.getPluginId()+".clst0000");

		return view;
	}
	
	public Action percentMode() {
		return ((ExecutionStatisticViewer2) getTraceViewer()).percentMode();
	}
	
	public Action deltaColumns() {
		return ((ExecutionStatisticViewer2) getTraceViewer()).deltaColumns();
	}	
	
	/**
	 * @return the Method Level action
	 */
	public Action getInstanceLevel() {
		return ((ExecutionStatisticViewer2) _viewer).getInstanceLevel();
	}
	
	public void updateButtons(int level)
	{
		super.updateButtons(level);
		
		getInstanceLevel().setChecked(ExecutionStatisticView.INSTANCE_LEVEL == level);
		deltaColumns().setEnabled(ExecutionStatisticView.INSTANCE_LEVEL != level);
	}
}
