/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MultiLevelStatisticMethodViewer.java,v 1.4 2005/02/16 22:24:03 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Vector;

import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticMethodView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

public abstract class MultiLevelStatisticMethodViewer extends MultiLevelStatisticViewer{
	
	protected Action _methodLevel;
	
	public MultiLevelStatisticMethodViewer() {
		super();
	}
	
	/**
	 * @return the method level action
	 */
	public Action getMethodLevel() {
		return _methodLevel;
	}	

	protected void setActionsNull()
	{
		super.setActionsNull();
		_methodLevel = null;
	}
	
	protected void getLevelActions(Vector actions)
	{
		super.getLevelActions(actions);
		
		String strMethodLevel = TraceUIPlugin.getString("STR_ST_METHOD_LEVEL");

		_methodLevel = new Action(strMethodLevel) {
			public void run() {
				MultiLevelStatisticPage page = (MultiLevelStatisticPage) getCurrentPage();

				if(page == null)
				{
				  revertChecked(_methodLevel);
				  return;
				}

				setCheckedLevels(page, MultiLevelStatisticMethodView.METHOD_LEVEL);

			}
			public int getStyle() {
				return IAction.AS_CHECK_BOX;
			}
		};
		_methodLevel.setText(strMethodLevel);
		TracePluginImages.setImageDescriptors(
			_methodLevel,
			TracePluginImages.T_LCL,
			TracePluginImages.IMG_METHOD);
		_methodLevel.setDescription(strMethodLevel);
		_methodLevel.setToolTipText(strMethodLevel);
		_methodLevel.setEnabled(true);
		
		actions.addElement(_methodLevel);
	}
}
