/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PatternPage.java,v 1.5 2005/02/16 22:24:03 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.internal.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;


/**
 * Insert the type's description here.
 * Creation date: (06/14/2000 12:34:21 PM)
 * @author: Administrator
 */
public class PatternPage extends TraceViewerPage
{
	protected Pattern  _view;
	
/**
 */
public PatternPage(EObject mofObject, TraceViewer _viewer)
{
	super(mofObject, _viewer);
}
/**
 * Insert the method's description here.
 * Creation date: (06/14/2000 12:38:21 PM)
 * @param parent com.ibm.swt.widgets.Composite
 */
public void createControl(Composite parent)
{
	_view = new Pattern(parent, this);		
	_view.initialize();

	setContextMenu(_view.getCanvas().canvas(), _view);
	makeActions();
}
/**
 * @see IPage#dispose
 */
public void dispose()
{
	if(_view != null && _view.getControl() != null)
		super.dispose();
	
	if(_view != null)
	  _view.dispose();
	  
	_mofObject = null;  
	_view = null;		  
}
/**
 * Returns the SWT control for this page
 *
 * @return the SWT control for this page
 */
public Control getControl() {
	return _view.getControl();
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 3:47:24 PM)
 * @return com.ibm.etools.trace.views.Pattern
 */
public Pattern getView() {
	return _view;
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 2:54:24 PM)
 */
public void makeActions()
{
	_viewer.makeActions();
}
public Action baseTime() {
	return((PatternViewer)_viewer).baseTime();
}

public Action rawTime() {
	return((PatternViewer)_viewer).rawTime();
}


/**
 * Insert the method's description here.
 * Creation date: (6/5/2001 2:45:25 PM)
 */
public void refreshPage()
{
	getView().refresh();
}
/**
 * Insert the method's description here.
 * Creation date: (6/5/2001 2:45:25 PM)
 */
public void selectionChanged()
{
	getView().selectionChanged();
}
/**
 * Sets focus to a part in the page.
 */
public void setFocus() {
	_view.getControl().setFocus();
}
/**
 * Insert the method's description here.
 * Creation date: (08/14/2000 5:50:25 PM)
 */
public void update(boolean newPage)
{
	if(newPage && _view != null)
		_view.updateUI();   
	
}

/**
 * Contribute to the view popup menu
 * @param menu
 */
public void fillContextMenu(IMenuManager menu)
{	
	if(_view != null)
	{
		_view.menuAboutToShow(menu);
	}
}

public boolean isEmpty()
{
	return _view.isEmpty();
}

}
