/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MultiLevelStatisticMethodView.java,v 1.4 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.widgets.Composite;

public abstract class MultiLevelStatisticMethodView extends MultiLevelStatisticView {

	public static final int METHOD_LEVEL = 3;
	
	protected abstract String getDefaultColumnsTemplateMethodLevel();
	
	public MultiLevelStatisticMethodView(Composite parent, TraceViewerPage page){
		super(parent, page);
	}	
	
	protected void searchInLevel(TableTree table,
			TableTreeItem item,
			TRCPackage pack,
			TRCClass cls,
			TRCMethod meth,
			TRCObject trcObj)
	{
		super.searchInLevel(table, item, pack, cls, meth, trcObj);
		
		switch (getLevel()) {
			case METHOD_LEVEL :
				if (meth != null)
					searchInMethodLevel(table, item, meth);
				break;
		}
	}
	
	public String getDefaultColumnsTemplate()
	{	
		String columns = super.getDefaultColumnsTemplate();
		
		if (columns == null && getLevel() == METHOD_LEVEL)
		{
			columns = getDefaultColumnsTemplateMethodLevel();
		}
	
		return columns;
	}
}
