/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StatisticalViewerUI.java,v 1.10 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.perfmon.internal.PerfmonCounterDialog;
import org.eclipse.hyades.statistical.ui.editor.internal.StatisticalModelGraphViewer;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Dirtiable;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.views.adapter.internal.StatisticalViewerPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StatisticalViewerUI extends StatisticalModelGraphViewer {

	protected StatisticalViewerPage _page;

	public StatisticalViewerUI(
		Composite parent,
		int style,
		boolean tabfolder, StatisticalViewerPage page
		, Dirtiable d,  URI current_project) {
		
		this(parent, style, tabfolder, d, current_project);
		
		_page = page;
	}

	public StatisticalViewerUI(
		Composite parent,
		int style,
		boolean tabfolder, StatisticalViewerPage page) {
			
	   this(parent, style, tabfolder);
					
		_page = page;
		
	}


	public StatisticalViewerUI(Composite parent, int style, boolean tabfolder) {		
		super(parent, style, tabfolder);
	}
	
	public StatisticalViewerUI(Composite parent, int style, boolean tabfolder, Dirtiable d,  URI current_project) {		

		super(parent, style, tabfolder, d,  current_project);

	}
	
	public void updateUI()
	{
	}
    
	public Control getControl()
	{
		return sashfolder;
	}
    
	public void selectionChanged()
	{
		if (sashfolder != null && !sashfolder.isDisposed() && sashfolder.isVisible() && !sashfolder.isFocusControl()) {
			//update viewer selection using common selection model
			//do nothing
			
		}
    	
	}
    
	public void refresh()
	{
		if (sashfolder != null && !sashfolder.isDisposed() && sashfolder.isVisible() && !sashfolder.isFocusControl()) {
			
			initialize();	
		}
		
	}

	class ConfigurePerfmonAction implements Runnable {
		Agent agent;
		TRCAgent trcagent;
		public ConfigurePerfmonAction(TRCAgent trcagent) {
			TRCAgentProxy aproxy = trcagent.getAgentProxy();
			Object obj = LoadersUtils.locateAgentInstance(aproxy);

			if (obj instanceof Agent) {
			
				Agent agent = (Agent)obj;
				if (agent != null) {
					if (agent.getType().equals("PerfmonAgent")) {
						this.trcagent = trcagent;
						this.agent = agent;

						//this is a perfmon agent - so add a menuitem to the agent node
						addAgentAction(trcagent,
										"CONFIGURE",
										PerfmonPlugin.getString("CONFIGURE_PERFMON"),
										PerfmonPlugin.img.getImage(ImageManager.IMG_PERFMON_LOGO),
										ConfigurePerfmonAction.this);

						//this is a perfmon agent - so add a menuitem to the descriptor nodes
						addModelAction(trcagent,
									"CONFIGURE",
									PerfmonPlugin.getString("CONFIGURE_PERFMON"),
									PerfmonPlugin.img.getImage(ImageManager.IMG_PERFMON_LOGO),
									ConfigurePerfmonAction.this);

					}
				}
			}
		}
		public void run() {
			PerfmonCounterDialog dialog = new PerfmonCounterDialog(getGraphWindow().getShell(),trcagent,agent);
			dialog.open();
			updateAgent(trcagent);
		}
	}
	
	public void initialize()
	{
		resetValues();
    	
		Object object = HyadesUtil.getMofObject();
		if(object == null || !(object instanceof EObject))
		  return;

		try {
			//update the statistical model tree
			getSDDescriptors((EObject)object);
			//set up the graph update button
			this.setConstantUpdate("VIEWER",true,1000);
		} catch (Exception exc)
		{
			exc.printStackTrace();
		}
		
		try{
			configureSliders();
		}
		catch(Exception exc)
		{
			exc.printStackTrace();
		}
	}
	
	private void configureSliders() throws Exception {
		TimeZoomSlider xslider = getGraphWindow().getXSlider(0);
		double minvis = xslider.getMinVisible();
		double maxvis = xslider.getMaxVisible();
		double min = xslider.getMinLimit();
		double max = xslider.getMaxLimit();
		
		double ctime = System.currentTimeMillis();
		
		minvis = ctime;
		maxvis = ctime + (1000 * 60);
		min = Math.min(min,ctime - (double)(1000 * 60 * 60));
		max = Math.max(max,ctime + (double)(1000 * 60 * 60 * 24));

		xslider.configure(min,max,minvis,maxvis,xslider.getResolution());		
		getGraphWindow().setTimeSliderFollowing(xslider, true);
		
		ZoomSlider yslider = getGraphWindow().getYSlider(0);
		minvis = yslider.getMinVisible();
		maxvis = Math.max(yslider.getMaxVisible(),100.0d);
		min = yslider.getMinLimit();
		max = Math.max(yslider.getMaxLimit(),maxvis*10);
		
		yslider.configure(min,max,minvis,maxvis,yslider.getResolution());			
	}
	

	protected void resetValues()
	{
	  if(reverse_map != null)
		reverse_map.clear();
	  if(graph_map != null)
		graph_map.clear();
	  if(sddescriptor_map != null)
		  sddescriptor_map.clear();
    	
	  if(chooser_tree != null)
		  chooser_tree.removeAll();
	  if(bar_map != null)
		bar_map.clear();
	  if(bar_slider_map != null)
		bar_slider_map.clear();
	  if(counter_map != null)
		counter_map.clear();
	  if(modifiable_map != null)
		modifiable_map.clear();     
	  if(source_map != null)
		source_map.clear();   	
    	
	  if(graph_window != null)
		  graph_window.removeAllGraphs();
	  next = 0;
	  prev_used = 0;	
	  
	  if(disposables != null)
	    disposables.clear();
	  if(modules != null)
	    modules.clear();
	      
	  model_change_listeners.clear();
	  agent_change_listeners.clear();
	  node_change_listeners.clear();
	  
	  if(trcagent_map != null)
	    trcagent_map.clear();
	  if(msglist_map != null)
	    msglist_map.clear();
	    
	   if(agents != null)
	     agents.clear();  	        
	}
	
	protected  void getSDDescriptors(EObject mofObject)
	{
	  if (mofObject != null) {
		  if (mofObject instanceof TRCAgentProxy) {
			  if (((TRCAgentProxy) mofObject).getAgent() != null) {
			  	
				  addAgent(((TRCAgentProxy) mofObject).getAgent());
				  new ConfigurePerfmonAction(((TRCAgentProxy) mofObject).getAgent());
			  }
		  } else if (mofObject instanceof TRCProcessProxy) {
			  Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

			  for (int idx = 0; idx < agents.length; idx++) {
				  if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
				  	
					addAgent(((TRCAgentProxy) agents[idx]).getAgent());
					new ConfigurePerfmonAction(((TRCAgentProxy) agents[idx]).getAgent());
				  	
				  }
			  }
		  } else if (mofObject instanceof TRCNode) {
			  Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

			  for (int idx = 0; idx < processes.length; idx++) {
				  Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

				  for (int i = 0; i < agents.length; i++) {
					  if (((TRCAgentProxy) agents[i]).getAgent() != null) {
					  	
						addAgent(((TRCAgentProxy) agents[i]).getAgent());
						new ConfigurePerfmonAction(((TRCAgentProxy) agents[i]).getAgent());
						  
					  }
				  }
			  }
		  } else if (mofObject instanceof TRCMonitor) {
			  Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

			  for (int k = 0; k < nodes.length; k++) {
				  Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

				  for (int idx = 0; idx < processes.length; idx++) {
					  Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

					  for (int i = 0; i < agents.length; i++) {
						  if (((TRCAgentProxy) agents[i]).getAgent() != null) {
						  	
							addAgent(((TRCAgentProxy) agents[i]).getAgent());
							new ConfigurePerfmonAction(((TRCAgentProxy) agents[i]).getAgent());
							  
						  }
					  }
				  }
			  }
		  }
	  }
   }		
}
