/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: UniqueValueClassification.java,v 1.4 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;

// UniqueValueClassification:  Classification where each bucket has one value
public class UniqueValueClassification extends CategoricalClassification
{
	protected ArrayList       _values;
	protected ArrayList       _labels;  // Order must match order of _values

	public UniqueValueClassification() {
		_values = new ArrayList();
		_labels = new ArrayList();
	}
	public void addValue(Object value, String label) {
		_values.add(value);
		_labels.add(label);
	}
	public int bucket(Object value) {
		// Do a linear search for now.  If we have cases where this is
		// too slow, we'll switch to a Hashtable.
		for (int i = 0; i < _values.size(); i++)
			if (_values.get(i).equals(value))
				return i;
		return NULL_BUCKET;
	}
	public void classify(ArrayList values) {

	}
	public String label(int n) {
		if (n == NULL_BUCKET)
			return _nullBucketLabel;
		else
			return (String)(_labels.get(n));
	}
	public int numBuckets() {
		return _values.size();
	}
}
