/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestHttpImages.java,v 1.5 2005/02/16 22:21:43 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http;

import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * Image manager for the Test HTTP plugin.
 *  
 * @author marcelop
 * @since 1.0.2
 */
public class TestHttpImages
extends ImageManager
{
	/**
	 * TestHttpImages' singleton.
	 */
	public static final TestHttpImages INSTANCE = new TestHttpImages();
	
	/*
	 * Available cached Images in the HTTP plugin image registry.
	 */
	public static final String IMG_WIZBAN_NEW_HTTP_TESTSUITE 		= "newhsuite_wiz.gif";
	public static final String IMG_WIZBAN_NEW_HTTP_TESTCASE 		= "newtest_wiz.gif";
	
	public static final String IMG_HTTP_TEST_SUITE 					= "hsuite.gif";
	public static final String IMG_HTTP_TEST_CASE 				    = "request.gif";
	public static final String IMG_CHECK		 				    = "check.gif";
	
	/**
	 * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
	 */
	protected void addImages()
	{
		add(T_WIZBAN, IMG_WIZBAN_NEW_HTTP_TESTSUITE);
		add(T_WIZBAN, IMG_WIZBAN_NEW_HTTP_TESTCASE);

		add(T_OBJ, IMG_HTTP_TEST_SUITE);
		add(T_OBJ, IMG_HTTP_TEST_CASE);
		add(T_OBJ, IMG_CHECK);
	}	
}
