/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpForm.java,v 1.5 2005/02/16 22:21:43 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.junit.editor;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.java.internal.junit.editor.JUnitForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class HttpForm 
extends JUnitForm
{
	/**
	 * Constructor for HttpForm
	 * @param junitEditorExtension
	 * @param widgetFactory
	 */
	public HttpForm(HttpEditorExtension httpEditorExtension, WidgetFactory widgetFactory)
	{
		super(httpEditorExtension, widgetFactory);
		setHeadingText(TestHttpPlugin.getString("EDT_GENERAL_INFO"));
	}


	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_FORM_CONTROL:
				break;
				
			case HELP_TEST_CASE_CONTROL:
				break;
				
			case HELP_TYPE_CONTROL:
				break;

			case HELP_FILE_CASE_CONTROL:
				break;
		}
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#createTestCaseElementsSectionControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementsSection)
	 */
	protected Control createTestCaseElementsSectionControl(Composite parent, NamedElementsSection testCaseElementsSection)
	{
		return testCaseElementsSection.createControl(parent, factory, TestHttpPlugin.getString("W_REQUESTS"), TestHttpPlugin.getString("EDT_REQUEST_DSC"));
	}
}
