/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpTestLaunchConfigurationFacade.java,v 1.8 2005/02/16 22:21:43 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;

/**
 * @author jnevicos
 * @author jcanches (bugzilla_64189)
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class HttpTestLaunchConfigurationFacade
		extends TestLaunchConfigurationFacade {
	
	public final static String LAUNCH_CONFIGURATION_TYPE =  "org.eclipse.hyades.test.http.launch.urlTest"; //$NON-NLS-1$
	
	public static ILaunchConfigurationType getLaunchConfigurationType() {
		return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(LAUNCH_CONFIGURATION_TYPE);
	}
	
	private final static String PROPERTY_URLTEST = PROPERTY_PREFIX + ".urlTest"; //$NON-NLS-1$
	public final static String PROPERTY_USERS = PROPERTY_URLTEST + ".users";

	public static int getNumberOfUsers(ILaunchConfiguration configuration) throws CoreException {
		return configuration.getAttribute(PROPERTY_USERS, 1);
	}
	
	public static void setNumberOfUsers(ILaunchConfigurationWorkingCopy configuration, int nb) {
		configuration.setAttribute(PROPERTY_USERS, nb);
	}
}
