/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ResponseTimeReportGenerator.java,v 1.7 2005/02/16 22:21:43 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.reports.responsetime;

import java.io.InputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.reports.HTTPReportGenerator;
import org.eclipse.hyades.test.http.internal.reports.ReportGraph;
import org.eclipse.hyades.test.http.internal.reports.ReportGraphConfiguration;
import org.eclipse.jface.viewers.ISelection;

/**
 * TODO: Provide description for "ReportGenerator1".
 * @see IReportGenerator
 */
public class ResponseTimeReportGenerator extends HTTPReportGenerator
{
	
	/**
	 * TODO: Implement "generate".
	 * @see IReportGenerator#generate
	 */
	public InputStream generate(IFile outputFile, ISelection sel) throws Exception 
	{
	 	initResultSelection();
	 	if(result==null)
			throw new Exception(TestHttpPlugin.getString("ResponseTimeReportGenerator.PROBLEM")); //$NON-NLS-1$
	 	 
	 	 ResponseTimeReport report = new ResponseTimeReport(result);
		 ResponseTimeData.resetCumulativeValues();
		 
		 report.generate();
		 		 
		 ReportGraphConfiguration graphConfig = setupConfiguration();
		 		 
		 ReportGraph graph = new ReportGraph(report.getList(),graphConfig);		 
		 IPath svgPath = outputFile.getFullPath(); 
		 svgPath.removeFileExtension().addFileExtension("svg");  //$NON-NLS-1$
		 return graph.generate(svgPath);	
	
	}

	private ReportGraphConfiguration setupConfiguration()
	{
		ReportGraphConfiguration graphConfig = new ReportGraphConfiguration();
		 graphConfig.setTitle(TestHttpPlugin.getString("ResponseTimeReportGenerator.RESPONSE_TIME")); //$NON-NLS-1$
		 graphConfig.setXTitle(TestHttpPlugin.getString("ResponseTimeReportGenerator.PAGE")); //$NON-NLS-1$
		 graphConfig.setYTitle(TestHttpPlugin.getString("ResponseTimeReportGenerator.TIME_S")); //$NON-NLS-1$
		 graphConfig.setLegendTitle(TestHttpPlugin.getString("ResponseTimeReportGenerator.LEGEND")); //$NON-NLS-1$
		 graphConfig.setTimeStampPrefix(""); //$NON-NLS-1$
		 graphConfig.setMinWidth(800);
		 graphConfig.setHeight(500);
		return graphConfig;
	}
}
