/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestInvocationPanel.java,v 1.3 2005/02/16 22:21:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui.panel;

import org.eclipse.hyades.test.manual.runner.model.TestCase;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.ui.util.EditorItem;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class TestInvocationPanel 
extends ActionPanel
{
	private static TestSuitePanel testSuitePanel;
	private static TestCasePanel testCasePanel;
		
	/**
	 * @see org.eclipse.hyades.test.manual.runner.ui.panel.NamedElementPanel#createControl()
	 */
	protected void createControl()
	{
		if(testSuitePanel == null)
			testSuitePanel = new TestSuitePanel();
		if(testCasePanel == null)
			testCasePanel = new TestCasePanel();

		super.createControl();		
	}
		
	/**
	 * @see BasePanel#isValidData(Object)
	 */
	protected boolean isValidData(Object data)
	{
		return (super.isValidData(data) && (data instanceof TestInvocation) && (((TestInvocation)data).getTest() != null));
	}

	/**
	 * @see org.eclipse.hyades.test.manual.runner.ui.util.IRefreshable#refreshContent(java.lang.Object)
	 */
	public void refreshContent(Object data)
	{
		super.refreshContent(data);
		
		if(data instanceof EditorItem)
		{
			NamedElementPanel testPanel = getTestPanel();
			if(testPanel != null)
			{
				EditorItem editorItem = (EditorItem)data;
				testPanel.refreshContent(new EditorItem(getTestInvocation().getTest(), editorItem.isEditable()));
			}
		}
	}
	

	public TestInvocation getTestInvocation()
	{
		return (TestInvocation)getCurrentData();
	}
	
	protected NamedElementPanel getTestPanel()
	{
		TestInvocation testInvocation = getTestInvocation();
		if(testInvocation != null)
		{
			if(testInvocation.getTest() instanceof TestSuite)
			{
				testSuitePanel.setVisible(true);
				testCasePanel.setVisible(false);
				return testSuitePanel;
			}
			
			if(testInvocation.getTest() instanceof TestCase)
			{
				testSuitePanel.setVisible(false);
				testCasePanel.setVisible(true);
				return testCasePanel;
			}
		}
		return null;
	}
}
