/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SDLogcPlugin.java,v 1.14 2005/02/16 22:21:32 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class SDLogcPlugin extends AbstractUIPlugin {
	/**
	 * The shared instance.
	 */
	private static SDLogcPlugin plugin;
	public static final String PLUGIN_ID = "org.eclipse.hyades.sd.logc"; //$NON-NLS-1$
	
	/**
	 * Resource bundle.
	 */
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public SDLogcPlugin() {
		plugin = this;
		
	}

	/**
	 * Returns the shared instance.
	 */
	public static SDLogcPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle= SDLogcPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		if(resourceBundle == null)
		{
			try {
				resourceBundle = Platform.getResourceBundle(Platform.getBundle(PLUGIN_ID));
			} catch (Exception e) {
				resourceBundle = null;
			}
		}
		
		return resourceBundle;
	}
	
	public static String getString(String key) {
		return getResourceString(key);
	}
	
	/**
	 * Logs an exception in Eclipse's .log file.
	 * @param e The exception to log.
	 */
	public static void log(Throwable e) { 
		String msg = e.getMessage();
		getDefault().getLog().log(new Status(IStatus.ERROR, getPluginId(), IStatus.ERROR, msg == null ? "" : msg, e));							
	}
	
	protected void initializeDefaultPreferences(IPreferenceStore store) {
		store.setDefault(SDLogcConstants.UML2SD_EXTEND_FILTER_OPTIONS, "");
		store.setDefault(SDLogcConstants.UML2SD_EXTEND_FIND_OPTIONS, "");
		store.setDefault(SDLogcConstants.UML2SD_FIND_DIRECTION_OPTIONS, "1");
		store.setDefault(SDLogcConstants.PAGE_SIZE, 500);
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugin#shutdown()
	 */
	/* (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		SDLogcPluginImages.shutdown();
		resourceBundle = null;
		
		savePluginPreferences();
	}

	public static String getPluginId() {
		return PLUGIN_ID;
	}
	
	public void log(IStatus status) {
		getLog().log(status);
	}
	
}
