/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogGraphNodeAction.java,v 1.5 2005/02/16 22:21:32 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.sd.logc.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.sd.logc.SDLogcConstants;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/**
 * Abstract class for objectContribution action delegates
 */
public abstract class LogGraphNodeAction implements IObjectActionDelegate {

	protected IAction action;
	protected IWorkbenchPart targetPart;
	protected List graphNodes;
	
	/**
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action_, IWorkbenchPart targetPart_) {
		if (targetPart_ instanceof org.eclipse.hyades.uml2sd.ui.view.SDView) {
			action = action_;
			targetPart = targetPart_;
		}
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action_) {
		if (action_ == action && targetPart != null && graphNodes != null) {
			IUml2SDLoader loader = LoadersManager.getLoadersManager().getCurrentLoader(SDLogcConstants.LogInteractionsViewID);
			if (loader instanceof LogInteractions) {
				run((LogInteractions)loader);
			}
		}
	}
	
	/**
	 * @param loader
	 */
	public abstract void run(LogInteractions loader);

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action_, ISelection selection_) {
		if (action_ == action) {
			graphNodes = new ArrayList();
			if (selection_ instanceof IStructuredSelection) {
				IStructuredSelection s = (IStructuredSelection)selection_;
				for (Iterator i = s.iterator(); i.hasNext(); ) {
					Object o = i.next();
					if (o instanceof LogGraphNode && isObjectValid((LogGraphNode)o) ) {
						graphNodes.add(o);
					}
				}
			}
		}
	}
	
	protected abstract boolean isObjectValid(LogGraphNode o);

}
