/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogGraphNodeExpandAction.java,v 1.4 2005/02/16 22:21:32 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.sd.logc.internal.actions;

import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

/**
 * Action delegate for 'Expand' on a on a group of log records
 */
public class LogGraphNodeExpandAction extends LogGraphNodeAction {

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.actions.internal.TraceGraphNodeAction#run(org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions)
	 */
	public void run(LogInteractions loader) {
		loader.expandLogGraphNode(graphNodes);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action_, ISelection selection_) {
		// TODO Auto-generated method stub
		super.selectionChanged(action_, selection_);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.sd.logc.internal.actions.LogGraphNodeAction#isObjectValid(org.eclipse.hyades.sd.logc.internal.uml2sd.LogGraphNode)
	 */
	protected boolean isObjectValid(LogGraphNode o) {
		return !o.isExpanded();
	}
}
