/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogInteractionsPreferencePage.java,v 1.8 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc.internal.preferences;

import java.text.MessageFormat;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.sd.logc.SDLogcConstants;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * CONTEXT_ID topp0000 for Filter Call Options preference page.
 */

public class LogInteractionsPreferencePage extends PreferencePage
										implements IWorkbenchPreferencePage, ModifyListener
{
	private Text txtPageSize;

	public LogInteractionsPreferencePage() {
		super();
	}
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

//		org.eclipse.ui.help.WorkbenchHelp.setHelp(
//			parent,
//			SDPlugin.getPluginId() + ".topp0000");

		GridLayout layout = new GridLayout();
		layout.marginWidth = 10;
		layout.marginHeight = 5;
		layout.numColumns = 2;
		composite.setLayout(layout);
		
		Label note = new Label(composite, SWT.WRAP);
		note.setText(SDLogcPlugin.getString("PAGE_SIZE_NOTE"));
		GridData data = new GridData();
		data.horizontalSpan=2;
		data.widthHint = 375;
		note.setLayoutData(data);
		
		Label dummy = new Label(composite, SWT.NULL);
		data = new GridData();
		data.horizontalSpan=2;
		data.grabExcessHorizontalSpace=true;
		dummy.setLayoutData(data);
		
		Label label = new Label(composite, SWT.NULL);
		label.setText(SDLogcPlugin.getString("STR_PAGE_SIZE"));
		txtPageSize = new Text(composite, SWT.BORDER);
		txtPageSize.setTextLimit(5);
		data = new GridData();
		data.widthHint = convertWidthInCharsToPixels(7);
		txtPageSize.setLayoutData(data);
		txtPageSize.setText(getPreferenceStore().getString(SDLogcConstants.PAGE_SIZE));
		txtPageSize.addModifyListener(this);
					    		
		return composite;
	}

	public IPreferenceStore getPreferenceStore() {
		return SDLogcPlugin.getDefault().getPreferenceStore(); 
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
		txtPageSize.setText(
			getPreferenceStore().getDefaultString(SDLogcConstants.PAGE_SIZE));
	}
	/**
	 * Restore defaults.
	 */
	protected void performDefaults() {
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();	
		IUml2SDLoader loader = LoadersManager.getLoadersManager().getCurrentLoader(SDLogcConstants.LogInteractionsViewID);
		if (loader instanceof ILogInteractionsPreferenceListener) {
			((ILogInteractionsPreferenceListener)loader).applyPreferences();
		}
		return true;
	}
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		getPreferenceStore().setValue(
		SDLogcConstants.PAGE_SIZE,
			txtPageSize.getText());
	}
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e) {
		IStatus status = validateInput();
		setValid(status.getSeverity()==IStatus.OK);
		if(status.getSeverity()==IStatus.ERROR)	
			setErrorMessage(status.getMessage());
		else
			setErrorMessage(null);
	}
	
	private IStatus validateInput(){
		
		String nrOfPages = txtPageSize.getText();
		
		PreferenceStatus status = new PreferenceStatus();
		
		if (nrOfPages.length() == 0) {			
			status.setMessage(SDLogcPlugin.getString("EMPTY_FIELD_MSG"));
			status.setSeverity(IStatus.ERROR);
		} else {
			try {
				int value= Integer.parseInt(nrOfPages);
				if (value <= 0) {
					status.setMessage(MessageFormat.format(SDLogcPlugin.getString("INVALID_PAGE_SIZE"),  new String[] {nrOfPages}));
					status.setSeverity(IStatus.ERROR);
				}
			} catch (NumberFormatException e) {
				status.setMessage(MessageFormat.format(SDLogcPlugin.getString("INVALID_PAGE_SIZE"),  new String[] {nrOfPages}));
				status.setSeverity(IStatus.ERROR);
			}
		}
		
		return status;

	}
	
	class PreferenceStatus extends Status{
		
		public PreferenceStatus(){
			super(OK, "hyades.sd.logc", 0, "", null);
		}
		
		
		/* (non-Javadoc)
		 * @see org.eclipse.core.runtime.Status#setMessage(java.lang.String)
		 */
		protected void setMessage(String message) {
			// TODO Auto-generated method stub
			super.setMessage(message);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.core.runtime.Status#setSeverity(int)
		 */
		protected void setSeverity(int severity) {
			// TODO Auto-generated method stub
			super.setSeverity(severity);
		}

	}

}
