/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogGraphNode.java,v 1.15 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.sd.logc.internal.uml2sd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.SDLogcPluginImages;
import org.eclipse.hyades.sd.logc.internal.util.LogcUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/**
 * @author ewchan
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class LogGraphNode extends ExecutionOccurrence implements IPropertySource, IActionFilter {

		private  EObject element;
		private List elements = null;
		private boolean expanded = false;
		private IPropertyDescriptor[] propertyDescriptors;
		private static String PROPERTY = "cbe.node.";

		protected LogGraphNode(){
		}
		
		public LogGraphNode(EObject element){
				this.element = element;
		}
		
		public EObject getElement(){
			
			if(!hasElements() || (hasElements() && isExpanded()))
				return element;					
			return (EObject)elements.get(0);			
		}
		
		public List getElements(){
			return elements;
		}
		
		public void addElement(EObject newElement){
			if(elements==null){
				elements = new ArrayList();
				if(element!=null)	
					elements.add(element);
			}
			elements.add(newElement);
		}
		
		public boolean hasElements(){
			return elements!=null && elements.size()>0;
		}
		
		public void setBackgroundColor(){
			short sev=0;
			if(!hasElements() || isExpanded()){
				sev = ((CBECommonBaseEvent)element).getSeverity();
			}else{
				CBECommonBaseEvent max = ((CBECommonBaseEvent)Collections.max(elements, new Comparator(){
					public int compare(Object o1, Object o2){
						if(((CBECommonBaseEvent) o1).getSeverity()>((CBECommonBaseEvent) o2).getSeverity()){
							return 1;
						}else if(((CBECommonBaseEvent) o1).getSeverity()==((CBECommonBaseEvent) o2).getSeverity()){
							return 0;
						}else{
							return -1;
						}
					}
				}));
				sev = max.getSeverity();
			}				
		   	      
			if(sev >=0 && sev <=70)
			{
			   if(sev >=50)
			   {
				   setFillColor(LogcUtil.redFill[0],LogcUtil.redFill[1],LogcUtil.redFill[2]);
				   setStrokeColor(LogcUtil.redStroke[0],LogcUtil.redStroke[1],LogcUtil.redStroke[2]);
				   
			   }
			   else if(sev >=30 && sev < 50)
			   {
					setFillColor(LogcUtil.yellowFill[0],LogcUtil.yellowFill[1],LogcUtil.yellowFill[2]);
 				    setStrokeColor(LogcUtil.yellowStroke[0],LogcUtil.yellowStroke[1],LogcUtil.yellowStroke[2]);
		          	   	      	 				          
			   }
			   else if(sev< 30)		   	      	 
			   {   	
					setFillColor(LogcUtil.blueFill[0],LogcUtil.blueFill[1],LogcUtil.blueFill[2]);
  				    setStrokeColor(LogcUtil.blueStroke[0],LogcUtil.blueStroke[1],LogcUtil.blueStroke[2]);
  	   	      	 				          
			   }
			  
			}
			
			if (hasElements()) {
				//parents
				if (isExpanded())
				{
					setImage(SDLogcPluginImages.getImage(SDLogcPluginImages.IMG_COLLAPSE_LOG_OVR));
				}
				else {
					setImage(SDLogcPluginImages.getImage(SDLogcPluginImages.IMG_EXPAND_LOG_OVR));
				}
			}
			
		}
		
		/* (non-Javadoc)
		 * @see org.eclipse.ui.views.properties.IPropertySource#getEditableValue()
		 */
		public Object getEditableValue() {
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyDescriptors()
		 */
		public IPropertyDescriptor[] getPropertyDescriptors() {
			if(!hasElements() || isExpanded()){
				if (propertyDescriptors == null) {
					propertyDescriptors = new IPropertyDescriptor[1];
					PropertyDescriptor cbeListsDescriptor = new PropertyDescriptor(PROPERTY, "["+CBEUtils.formatCreationTime((CBECommonBaseEvent)element,LogUIPlugin.getDateTimeFormat())+"] "+((CBECommonBaseEvent)element).getMsg());
					cbeListsDescriptor.setLabelProvider(new LabelProvider() {
			               public String getText(Object element) {
							return TString.change(SDLogcPlugin.getString("STR_SEVERITY_A"),"%1",""+((CBECommonBaseEvent)element).getSeverity());
			               }
			            });
					propertyDescriptors[0]=cbeListsDescriptor;
				}
			}else{
				if (propertyDescriptors == null) {
					propertyDescriptors = new IPropertyDescriptor[elements.size()];
					for (int i=0;i<elements.size();i++) {
						PropertyDescriptor cbeListsDescriptor = new PropertyDescriptor(PROPERTY+i, i+": ["+CBEUtils.formatCreationTime((CBECommonBaseEvent)elements.get(i),LogUIPlugin.getDateTimeFormat())+"] "+((CBECommonBaseEvent)elements.get(i)).getMsg());
						final int idx = i;
						cbeListsDescriptor.setLabelProvider(new LabelProvider() {
				               public String getText(Object element) {
				               	return TString.change(SDLogcPlugin.getString("STR_SEVERITY_A"),"%1",""+((CBECommonBaseEvent)elements.get(idx)).getSeverity());
				               }
				            });
						
						cbeListsDescriptor.setCategory(TString.change(SDLogcPlugin.getString("STR_CBES"),"%1",""+elements.size()));
						propertyDescriptors[i]=cbeListsDescriptor;
		            }
				}				
			}
	        return propertyDescriptors;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyValue(java.lang.Object)
		 */
		public Object getPropertyValue(Object id) {
			if(!hasElements() || isExpanded()){
				return element;			   
			}else{
				return elements;
			}
		}

		/* (non-Javadoc)
		 * @see org.eclipse.ui.views.properties.IPropertySource#isPropertySet(java.lang.Object)
		 */
		public boolean isPropertySet(Object id) {
			return false;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.ui.views.properties.IPropertySource#resetPropertyValue(java.lang.Object)
		 */
		public void resetPropertyValue(Object id) {	}

		/* (non-Javadoc)
		 * @see org.eclipse.ui.views.properties.IPropertySource#setPropertyValue(java.lang.Object, java.lang.Object)
		 */
		public void setPropertyValue(Object id, Object value) {	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionFilter#testAttribute(java.lang.Object, java.lang.String, java.lang.String)
	 */
	public boolean testAttribute(Object target, String name, String value) {
		if(target instanceof LogGraphNode){
			if(name.equals("isExpanded") && value.equals("true"))
				return ((LogGraphNode)target).isExpanded();
			if(name.equals("isExpanded") && value.equals("false"))
				return  ((LogGraphNode)target).hasElements() && !((LogGraphNode)target).isExpanded();
			
		}
		return false;
	}
		/**
		 * @return Returns the expanded.
		 */
		public boolean isExpanded() {
			return expanded;
		}
		/**
		 * @param expanded The expanded to set.
		 */
		public void setExpanded(boolean expanded) {
			this.expanded = expanded;
		}
}
