/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMISymptomDatabase.java,v 1.3 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.analysis;

import java.util.*;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.analysis.engine.*;
import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;

final class XMISymptomDatabase implements ISymptomDatabase {

	private SDBRuntime fDatabase = null;
	private String symptomDBPath = null;

        public String getPath(){
            return symptomDBPath;
        }
	
	public synchronized boolean load() {

		unload();

		fDatabase = loadDatabase(symptomDBPath);

		return (fDatabase != null);
	}

	public synchronized boolean unload() {

		ResourceSet resourceSet = SDBResourceSetImpl.getInstance();
		if(fDatabase!=null && resourceSet!=null){
			resourceSet.getResources().remove(fDatabase.eResource());
		}
		fDatabase = null;

		return true;
	}

	public synchronized boolean merge(String symptomDbPath) {

		SDBRuntime newDatabase = loadDatabase(symptomDbPath);

		if (newDatabase == null)
			return false;

		if (fDatabase == null)
			fDatabase = newDatabase;

		else {

			EList symptoms = newDatabase.getSymptoms();
			for (int idx = 0; idx < symptoms.size(); idx++) {
				SDBSymptom symptom = (SDBSymptom) symptoms.get(idx);

				boolean found = false;
				EList fSymptoms = fDatabase.getSymptoms();
				for (int i = 0; i < fSymptoms.size(); i++) {
					SDBSymptom fSymptom = (SDBSymptom) fSymptoms.get(i);
					if (symptom.getDescription().equals(fSymptom.getDescription())) {
						found = true;
						break;
					}
				}

				if (!found) {
					SDBSymptom _symptom = SDBFactory.eINSTANCE.createSDBSymptom();
					_symptom.setDescription(symptom.getDescription());
					fDatabase.getSymptoms().add(_symptom);

					//add patterns				  	
					EList patterns = symptom.getPatterns();
					for (int i = 0; i < patterns.size(); i++) {
						SDBMatchPattern pattern = (SDBMatchPattern) patterns.get(i);

						SDBMatchPattern _pattern = SDBFactory.eINSTANCE.createSDBMatchPattern();
						_pattern.setName(pattern.getName());
						_pattern.setValue(pattern.getValue());

						_symptom.getPatterns().add(_pattern);
					}

					//add solutions
					EList solutions = symptom.getSolutions();
					for (int i = 0; i < solutions.size(); i++) {
						SDBSolution solution = (SDBSolution) solutions.get(i);

						SDBSolution _solution = SDBFactory.eINSTANCE.createSDBSolution();
						_solution.setDescription(solution.getDescription());

						_symptom.getSolutions().add(_solution);
						fDatabase.getSolutions().add(_solution);
					}
				}
			}
		}

		return true;
	}

	public Solution[] getSolutions(Incident incident) {
		return null;
	}

	public Object[] getDirectives(Incident incident) {

		ArrayList directives = new ArrayList();

		if (fDatabase != null) {

			String incidentId = incident.getMessageId();

			if ((incidentId != null) && (!incidentId.trim().equals(""))) {

				EList symptoms = fDatabase.getSymptoms();
				StringTokenizer tokens;
				boolean match = false;

				for (int idx = 0; idx < symptoms.size(); idx++) {
					SDBSymptom symptom = (SDBSymptom) symptoms.get(idx);
					if (symptom == null)
						continue;

					EList patterns = symptom.getPatterns();
					
					if (patterns.size() == 0) {
						match = true;
						if (symptom.getDescription().trim().equals("") || incidentId.indexOf(symptom.getDescription()) == -1) {
							match = false;
							continue;
						}
					} else {
						int numNullString = 0;
						match = (patterns.size() > 0);
						for (int i = 0; i < patterns.size(); i++) {
							SDBMatchPattern pattern = (SDBMatchPattern) patterns.get(i);
							if (pattern.getValue().equals("")) {
								numNullString++;
							}
							else if (incidentId.indexOf(pattern.getValue()) == -1) {
								match = false;
								break;
							}
						}
						if (numNullString == patterns.size()) {
							match = true;
							if (incidentId.indexOf(symptom.getDescription()) == -1) {
								match = false;
								continue;
							}			
						}
					}

					if (match) {
						
						directives.add(symptom);
					}
				}
			}
		}

		return directives.toArray();
	}

	private SDBRuntime loadDatabase(String path) {
		try {
			
			Resource res = null;
			ResourceSet resourceSet = SDBResourceSetImpl.getInstance();			
			if(resourceSet!=null){	
				if(path.startsWith("platform:/resource")){
					res = resourceSet.getResource(URI.createURI(path), true);
				}
				else{
					res = resourceSet.getResource(URI.createFileURI(path), true);					
				}

			}
			
			Iterator i = res.getContents().iterator();
			while (i.hasNext()) {
				Object obj = i.next();
				if (obj instanceof SDBRuntime) {
					return (SDBRuntime) obj;
				}
			}
		}
		catch (Exception e) {
			e.printStackTrace();
			return null;
		}

		return null;
	}

	public boolean replace(String symptomDbPath) {

		this.symptomDBPath = symptomDbPath;

		if (symptomDBPath == null)
			return (unload());

		return (load());
	}
	
}
