/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DBDetails.java,v 1.7 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.editors;

import org.eclipse.emf.ecore.*;
import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.hyades.sdb.internal.*;
import org.eclipse.hyades.sdb.internal.help.*;
import org.eclipse.hyades.sdb.internal.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.help.*;

public class DBDetails extends Composite implements IDetails, Listener, FocusListener {

	private Text txtDBName;
	private Text txtURL;
	private Text txtExtLocation;
	private Text txtDescription;
    private boolean isDisplaying = false;
    private SymptomDBEditor editor; 
    private SDBRuntime currentSel = null;
	private Widget wLastSelected;    
	
	
	public DBDetails(RASWidgetFactory factory, Composite composite, int style){

		super(composite, style);

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 1;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		
		Label lblDBName = factory.createLabel(this, SDbPlugin.getResourceString("STR_SYPMTOMDBNAME_LABEL"), SWT.NONE);
	
		txtDBName = factory.createText(this, "", SWT.MULTI);
		txtDBName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		txtDBName.setData(new Integer(0));
			
		Label lblURL = factory.createLabel(this, SDbPlugin.getResourceString("STR_URL_LABEL"),SWT.NONE);
	
		txtURL = factory.createText(this, "",  SWT.MULTI);
		txtURL.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		txtURL.setData(new Integer(1));
	
		Label lblExtLocation = factory.createLabel(this,SDbPlugin.getResourceString("STR_EXTERNALLOC_LABEL"),SWT.NONE);
		txtExtLocation = factory.createText(this, "",SWT.MULTI);
		txtExtLocation.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		txtExtLocation.setData(new Integer(2));
	
		Label lblDescription = factory.createLabel(this,SDbPlugin.getResourceString("STR_DESCRIPTION_LABEL"),SWT.NONE);
		txtDescription = factory.createText(this, "",SWT.NONE|SWT.V_SCROLL|SWT.H_SCROLL | SWT.MULTI);
		GridData descLayout =  new GridData(GridData.FILL_BOTH);
		//descLayout.heightHint = 45;
		//descLayout.verticalSpan = 3;	
		txtDescription.setLayoutData(descLayout);
		txtDescription.setData(new Integer(3));
		
		WorkbenchHelp.setHelp(txtDBName, ContextIds.SYMDB_EDITOR_DETAILS_NAME);
		WorkbenchHelp.setHelp(txtURL, ContextIds.SYMDB_EDITOR_DETAILS_URL);
		WorkbenchHelp.setHelp(txtExtLocation, ContextIds.SYMDB_EDITOR_DETAILS_LOCATION);
		WorkbenchHelp.setHelp(txtDescription, ContextIds.SYMDB_EDITOR_DETAILS_DESCRIPTION);

		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		txtDBName.addListener(SWT.Modify, this);
		txtURL.addListener(SWT.Modify, this);
		txtExtLocation.addListener(SWT.Modify, this);
		txtDescription.addListener(SWT.Modify, this);
		
		txtDBName.addFocusListener(this);
		txtURL.addFocusListener(this);
		txtExtLocation.addFocusListener(this);
		txtDescription.addFocusListener(this);
		
		wLastSelected = null;		
	}
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {

		currentSel = (SDBRuntime)object;
		isDisplaying = true;
		txtDBName.setText(currentSel.getName()==null?"":currentSel.getName());
		txtURL.setText(currentSel.getSymptomUrl()==null?"":currentSel.getSymptomUrl());
		txtExtLocation.setText(currentSel.getLocalExternalFileLocation()==null?"":currentSel.getLocalExternalFileLocation());
		txtDescription.setText(currentSel.getDescription()==null?"":currentSel.getDescription());
		isDisplaying = false;
		wLastSelected = null;
	}

    public void init(SymptomDBEditor editor){
		this.editor = editor;
    }

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

		currentSel = (SDBRuntime)currentSelection;
		currentSel.setName(txtDBName.getText());
		currentSel.setSymptomUrl(txtURL.getText());
		currentSel.setLocalExternalFileLocation(txtExtLocation.getText());
		currentSel.setDescription(txtDescription.getText());
		return false;

	}
	
	public void focusGained(FocusEvent e)
	{
		wLastSelected = e.widget;	
	}
 
	public void focusLost(FocusEvent e)
	{
		
	}	
	
	public void setFocusToTextBox(){
		setFocusToTextBox(0, txtDBName.getText().length());
	}

	public void setFocusToTextBox(int startIndex, int endIndex){
		int strLength;
		int nlLength = SymptomDBSearchDialog.getFieldSeparator().length();		
		
		strLength = 0; 
		if (startIndex < (strLength + txtDBName.getText().length()))
		{
			txtDBName.setSelection(startIndex-strLength, endIndex-strLength);
			wLastSelected = txtDBName;
			return;
		}
		
		strLength = strLength + txtDBName.getText().length() + nlLength; 

		if(startIndex < (strLength + txtURL.getText().length()))		
		{
			txtURL.setSelection(startIndex-strLength, endIndex-strLength);
			wLastSelected = txtURL;			
			return;
		}
		
		strLength = strLength + txtURL.getText().length() + nlLength;
		
		if(startIndex < (strLength + txtExtLocation.getText().length()))
		{
			txtExtLocation.setSelection(startIndex-strLength, endIndex-strLength);
			wLastSelected = txtExtLocation;			
			return;
		}
		
		strLength = strLength + txtExtLocation.getText().length() + nlLength;		
		
		txtDescription.setSelection(startIndex-strLength, endIndex-strLength);
		wLastSelected = txtDescription;
	}
		
	
	public int getCursorPosition()
	{
		int nlLength = SymptomDBSearchDialog.getFieldSeparator().length();
		
		int strLength = 0;
		
		if (wLastSelected == txtDBName)
			return strLength + SymptomDBSearchDialog.getCursorPosForSelection(txtDBName);
		
		strLength = strLength + txtDBName.getText().length() + nlLength;
		
		if (wLastSelected == txtURL)
			return strLength + SymptomDBSearchDialog.getCursorPosForSelection(txtURL);
		
		strLength = strLength + txtURL.getText().length() + nlLength;		

		if (wLastSelected == txtExtLocation)
			return strLength + SymptomDBSearchDialog.getCursorPosForSelection(txtExtLocation);

		strLength = strLength + txtExtLocation.getText().length() + nlLength;		
		
		if (wLastSelected == txtDescription)
			return strLength + SymptomDBSearchDialog.getCursorPosForSelection(txtDescription);
		
		if (wLastSelected == null)
			return -1;

		return 0;
	}
	

	/**
	 * @see Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event) {
    	Widget source = event.widget;
		boolean status = false;

    	if(currentSel!=null && isDisplaying==false){
    		switch(((Integer)source.getData()).intValue()){
    			case 0: status = editor.validateState(txtDBName, this, currentSel.getName()==null?"":currentSel.getName());
    					break;
    			case 1: status = editor.validateState(txtURL, this, currentSel.getSymptomUrl()==null?"":currentSel.getSymptomUrl());
    					break;
				case 2: status = editor.validateState(txtExtLocation, this, currentSel.getLocalExternalFileLocation()==null?"":currentSel.getLocalExternalFileLocation());
						break;
				case 3: status = editor.validateState(txtDescription, this, currentSel.getDescription()==null?"":currentSel.getDescription());
						break;
    		}
			
			if(status){
	    		editor.updateUIDirtyStatus(true);
				editor.updateModelDirtyStatus(true);
    		}

    	}


	}
	
}
