/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SymptomDBDialog.java,v 1.6 2005/05/06 04:05:42 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.preferences;

import org.eclipse.hyades.ui.internal.util.PreferencesUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/**
 * 
 */
public class SymptomDBDialog extends Dialog {
	
	private SymptomDBUI _options;

	private java.lang.String _title;
	/**
	 * CoulmnsDialog constructor comment.
	 * @param windowTitle java.lang.String
	 * @param windowImage com.ibm.swt.graphics.Image
	 */
	public SymptomDBDialog(Shell shell, String windowTitle, Image windowImage) {
		super(shell);
		_title = windowTitle;
		setDefaultImage(windowImage);
	}
	/**
	 * Configures the given shell in prepartaion for opening this window
	 * in it.
	 * <p>
	 * The default implementation of this framework method
	 * sets the shell's image and gives it a grid layout. 
	 * Subclasses may extend or reimplement.
	 * </p>
	 * 
	 * @param newShell the shell
	 */
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}
	/**
	 * Creates and returns the contents of the upper part 
	 * of the dialog (above the button bar).
	 *
	 * Subclasses should overide.
	 *
	 * @param the parent composite to contain the dialog area
	 * @return the dialog area control
	 */
	protected Control createDialogArea(Composite parent) {
		Composite result = (Composite) super.createDialogArea(parent);

		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		result.setLayout(layout);

		_options = new SymptomDBUI();
		_options.createControl(result);

		IPreferenceStore store = PreferencesUtil.doGetPreferenceStore();
		String path = store.getString(PreferencesUtil.SYMPTOM_DB_PATH_KEY);
		_options.addDBPath(path);

		return result;
	}
	/**
	* Notifies that the ok button of this dialog has been pressed.
	* <p>
	* The default implementation of this framework method sets
	* this dialog's return code to <code>Window.OK</code>
	* and closes the dialog. Subclasses may override.
	* </p>
	*/
	protected void okPressed() {

		_options.storeValues(PreferencesUtil.doGetPreferenceStore());

		super.okPressed();
	}

}
