/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SymptomDBExportToV4Util.java,v 1.6 2005/02/18 23:54:45 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.util;

import java.text.*;
import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.*;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;
import org.eclipse.hyades.models.internal.sdb.*;

public class SymptomDBExportToV4Util
{
 
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + NL + "" + NL + "<!DOCTYPE symfile [" + NL + "<!-- ../dtd/symlog.dtd -->" + NL + "<!ELEMENT symrec ( matchsymptomv | nomatchsymptomv | symptominfov )* >" + NL + "<!ATTLIST symrec" + NL + "       recordid CDATA #REQUIRED" + NL + "       symptomtype CDATA #IMPLIED" + NL + "       symptomstatus CDATA #IMPLIED>" + NL + "" + NL + "<!ELEMENT symfile ( filterrecv | symrecv )* >" + NL + "<!ATTLIST symfile" + NL + "       totalrecords CDATA #IMPLIED" + NL + "       filtername CDATA #REQUIRED>" + NL + "" + NL + "<!ELEMENT symrecv ( symrec )* >" + NL + "" + NL + "<!ELEMENT nomatchsymptomv ( #PCDATA )* >" + NL + "" + NL + "<!ELEMENT symfilterrec ( symrecv | symfilterrecv )* >" + NL + "<!ATTLIST symfilterrec" + NL + "       filtername CDATA #REQUIRED" + NL + "       filtervalue CDATA #IMPLIED" + NL + "       sortfield CDATA #IMPLIED" + NL + "       severity CDATA #REQUIRED>" + NL + "" + NL + "<!ELEMENT filterrecv ( symfilterrec )* >" + NL + "" + NL + "<!ELEMENT matchsymptomv ( #PCDATA )* >" + NL + "" + NL + "<!ELEMENT symptominfov ( #PCDATA )* >" + NL + "" + NL + "<!ELEMENT symfilterrecv ( symfilterrec )* >" + NL + "" + NL + "]>" + NL + "" + NL + "<!--  Created on " + new SimpleDateFormat("EEEE, MMMMM dd, yyyy 'at' h:mm:ss:SSSS a z").format(new Date()) + " -->" + NL;
  protected final String TEXT_2 = NL + "<symfile totalrecords=\"";
  protected final String TEXT_3 = "\" filtername=\"None\">" + NL + "  <symrecv>";
  protected final String SYMPTOM_START = NL + "    <symrec recordid=\"%1";
  protected final String SYMPTOM = "Symptom_";
  
  protected final String TEXT_5 = "\" symptomtype=\"\" symptomstatus=\"diagnosed\">" + NL + "      <matchsymptomv>";
  protected final String TEXT_6 = NL;
  protected final String TEXT_7 = NL + "      </matchsymptomv>";
  protected final String SYMPTOMINFO_START =  NL + "      <symptominfov>";
  //protected final String TEXT_8 = NL;
  //protected final String TEXT_9 = NL;
  protected final String SYMPTOMIFO_END = NL + "      </symptominfov>";
  protected final String SYMPTOM_END = NL + "    </symrec>";
  protected final String TEXT_11 = NL + "  </symrecv>" + NL + "</symfile>";

 	public String normalize(String string) {

		if (string == null)
			return "null";

		StringBuffer normalizedString = new StringBuffer();
		char character;

		//Check all characters 
		for (int counter = 0; counter < string.length(); counter++) {

			character = string.charAt(counter);

			if (character == '<')
				normalizedString.append("&lt;");

			else if (character == '>')
				normalizedString.append("&gt;");

			else if (character == '&')
				normalizedString.append("&amp;");

			else if (character == '"')
				normalizedString.append("&quot;");

			else if (character == '\'')
				normalizedString.append("&apos;");

			else
				normalizedString.append(character);
		}

		return (normalizedString.toString());
	}
 
  /**
   * Generate symtom db xml v4 from a SDBRuntime object
   */
  public String generate(SDBRuntime root, IProgressMonitor monitor) {
		StringBuffer stringBuffer = new StringBuffer();
		stringBuffer.append(TEXT_1);
		EList symptList = root.getSymptoms();
		int units = symptList.size();

		stringBuffer.append(TEXT_2);
		stringBuffer.append(units);
		stringBuffer.append(TEXT_3);

		for (int i = 0; i < symptList.size(); i++) {
			SDBSymptom current = (SDBSymptom) symptList.get(i);
			EList solList = current.getSolutions();
			EList matchPatterns = current.getPatterns();
			if(current.getDescription().length()==0){	
				stringBuffer.append(StringUtil.change(SYMPTOM_START,"%1",SYMPTOM));
				stringBuffer.append(i);
			}else{
				stringBuffer.append(StringUtil.change(SYMPTOM_START,"%1",normalize(current.getDescription())));
			}
			
			stringBuffer.append(TEXT_5);

			for (int j = 0; j < matchPatterns.size(); j++) {
				stringBuffer.append(TEXT_6);
				stringBuffer.append(normalize(((SDBMatchPattern) matchPatterns
						.get(j)).getValue()));
			}
			stringBuffer.append(TEXT_7);

			for (int j = 0; j < solList.size(); j++) {
				SDBSolution sol = (SDBSolution) solList.get(j);
				EList dirList = sol.getDirectives();
				stringBuffer.append(SYMPTOMINFO_START);
				if (sol.getDescription().length() > 0) {
					stringBuffer.append(NL);
					stringBuffer.append(normalize(sol.getDescription()));
				}

				for (int k = 0; k < dirList.size(); k++) {
					SDBDirective dir = (SDBDirective) dirList.get(k);
					if (dir.getDescription().length() > 0) {
						stringBuffer.append(NL);
						stringBuffer.append(normalize(dir.getDescription()));
					}
					if (dir.getDirectiveString().length() > 0) {
						stringBuffer.append(NL);
						stringBuffer
								.append(normalize(dir.getDirectiveString()));
					}
				}

				stringBuffer.append(SYMPTOMIFO_END);
			}
			stringBuffer.append(SYMPTOM_END);

			monitor.worked(8000 / units);
		}
		stringBuffer.append(TEXT_11);
		return stringBuffer.toString();
	}
}
