/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SymptomDBTextSearch.java,v 1.7 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.internal.sdb.*;

/**
 * This class offers search capability through the Symptom Database
 */
public class SymptomDBTextSearch {

	private SDBRuntime root;
	private Object[] start =null;
	private int[] startIndex = null;
	private int[] index = null;
	SymptomDBSearchDialog sd;
	
	/**
	 * Constructor for SymptomDBTextSearch.
	 */
	public SymptomDBTextSearch(SymptomDBSearchDialog p_sd) {
		super();
		sd = p_sd;
	    startIndex = new int[]{-1,-1,-1,-1,-1};
	    index = new int[]{-1,-1,-1,-1, -1};
	}

	public void initialize(SDBRuntime root, Object[] p_start){
		this.root = root;
		setIndex(-1,-1,-1,-1,-1);
		setStartIndex(-1, -1, -1, -1, startIndex[4]);
		lookForStartNode(p_start);
	}	
	/**
	 * 
	 */
	public Object[] search(String pattern, int direction, boolean bCaseSensitive){
					
		if(startIndex==null){
	        setStartIndex(-1,-1,-1,-1,-1);	
			lookForStartNode(start);
		}
		
		if(startIndex[1]==-1 && direction>0){
			
			setIndex(0,0,0,0, startIndex[4]);
			return searchDown(pattern, bCaseSensitive);
		}
		
		if(startIndex[1]==-1 && direction<0){
			startIndex[0] = -1;
			setIndex(startIndex[0], startIndex[1], startIndex[2], startIndex[3], startIndex[4]);
			return searchUp(pattern, bCaseSensitive);
		}
		
		if(startIndex[2]==-1 && direction>0){
			setIndex(0,startIndex[1],0,0, startIndex[4]);
			return searchDown(pattern, bCaseSensitive);
		}
		
		if(startIndex[2]==-1 && direction<0){
//			if(startIndex[1]-1>=0){
//				// search has to begin with the last solution and last directive of the previous symptom
//				setIndex(0,startIndex[1]-1,-11,-11, startIndex[4]);
//				return searchUp(pattern, bCaseSensitive);
//			}
//			else{
				setIndex(0,startIndex[1],-1,-1, startIndex[4]);
				return searchUp(pattern, bCaseSensitive);
//			}
		}

		if(startIndex[3]==-1 && direction>0){
			setIndex(0,startIndex[1], startIndex[2],0, startIndex[4]);
			return searchDown(pattern, bCaseSensitive);
		}
				
		if(startIndex[3]==-1 && direction<0){
//			if(startIndex[2] -1 >=0){
//				setIndex(0,startIndex[1],startIndex[2] -1,-11, startIndex[4]);
//				// search has to begin with the last last directive of the previous solution
//				return searchUp(pattern, bCaseSensitive);
//			}			
//			else{
				setIndex(0,startIndex[1],startIndex[2],-1, startIndex[4]);
				return searchUp(pattern, bCaseSensitive);
//			}
		}		

        if(direction>0){
        	setIndex(0,startIndex[1],startIndex[2],startIndex[3], startIndex[4]);
        	return searchDown(pattern, bCaseSensitive);
        }
        else{
        	setIndex(0,startIndex[1],startIndex[2],startIndex[3], startIndex[4]);
        	return searchUp(pattern, bCaseSensitive);
        }
        	                        
	}
	

	private void lookForStartNode(Object[] p_start){
		this.start = p_start;
		
		if (start[4] != null && start[4] instanceof Integer)
		{
			startIndex[4] = ((Integer)start[4]).intValue();
		}
		else
		{
			startIndex[4] = -1;
		}
				
		if(start[0]==null){
			startIndex[0] = -1;
			return;					
		}

		startIndex[0]= 0;
		if(start[1]==null){
			return;		
		}

		EList symptoms = root.getSymptoms();		
		startIndex[1] = symptoms.indexOf((SDBSymptom)start[1]);

		if(start[2]==null){
			startIndex[2] = -1;
			return;
		}

		SDBSymptom symptom = (SDBSymptom) start[1];
		EList solutions = symptom.getSolutions();
		
		startIndex[2] = solutions.indexOf((SDBSolution)start[2]);
		
		if(start[3]==null){
			startIndex[3] = -1;
			return;		
		}
						
		SDBSolution sol = (SDBSolution) start[2];
		EList directives = sol.getDirectives();
		
		startIndex[3] = directives.indexOf((SDBDirective)start[3]);
		return;
	}
	
	private String stringForDisplay(String s)
	{
		return sd.fixText(s);
	}
	
	private int searchPatternIn(String pattern, String target, int startFrom, boolean bCaseSensitive, boolean searchDown){

		if(bCaseSensitive){
			if (searchDown)
				return stringForDisplay(target).indexOf(pattern, startFrom+1);
			else
				return stringForDisplay(target).lastIndexOf(pattern, startFrom>=0?startFrom-1:target.length());
		}
		else{
			target = target.toLowerCase();
			pattern = pattern.toLowerCase();
			if (searchDown)
				return stringForDisplay(target).indexOf(pattern, startFrom+1);
			else
				return stringForDisplay(target).lastIndexOf(pattern, startFrom>=0?startFrom-1:target.length());
			
		}
	}
	
   private Object[] searchDown(String pattern, boolean bCaseSensitive){
   			int searchIndex = -1;
   			
   			String nl = SymptomDBSearchDialog.getFieldSeparator();
   	
			if(startIndex[0] < 0 || startIndex[1] < 0){
				searchIndex = searchPatternIn(pattern, root.getName() + nl + root.getSymptomUrl() + nl + root.getLocalExternalFileLocation() + nl + root.getDescription(),startIndex[4], bCaseSensitive, true);
				if(searchIndex >= 0){
					setStartIndex(0,-1,-1,-1, searchIndex);
					setStartObject(root, null, null, null, searchIndex, searchIndex+pattern.length());
					return start;
				}
				else
				{
					startIndex[4] = -1;
				}
			}

			EList symptoms = root.getSymptoms();
			int k=index[2];
			int l=index[3];
			for(int i=index[1];i>=0 && i<symptoms.size();i++){
				SDBSymptom symptom = (SDBSymptom)symptoms.get(i);
				if(i!=startIndex[1] || (i==startIndex[1] && startIndex[2]==-1)){


					String searchStr = symptom.getDescription() + nl;
					
					String mnl = System.getProperties().getProperty("line.separator");
					
					EList patterns = symptom.getPatterns();	
					for(int j=0;j<patterns.size();j++){
						SDBMatchPattern match = (SDBMatchPattern)patterns.get(j);
						searchStr = searchStr + match.getValue() + mnl;//HERE bug 71785
					}

					searchIndex = searchPatternIn(pattern, searchStr, startIndex[4], bCaseSensitive, true);
					if(searchIndex >= 0){
						setStartIndex(0,i,-1,-1, searchIndex);
						setStartObject(root,symptom,null,null, searchIndex, searchIndex+pattern.length());
						return start;					
					}
					else
					{
						startIndex[4]=-1;
					}					
					
					
				}
				EList solutions = symptom.getSolutions();				
				
				for(;k>=0 && k<solutions.size();k++){
					
					SDBSolution sol = (SDBSolution)solutions.get(k);
					if(!(i==startIndex[1] && k==startIndex[2]) || startIndex[3]==-1){
						searchIndex = searchPatternIn(pattern, sol.getDescription(), startIndex[4], bCaseSensitive, true); 
						if(searchIndex >= 0){
							setStartIndex(0,i,k,-1, searchIndex);
							setStartObject(root,symptom,sol,null, searchIndex, searchIndex+pattern.length());						   
							return start;					
						}
						else
						{
							startIndex[4] = -1;
						}
					}	
					
					EList directives = sol.getDirectives();
										
					for(;l>=0 && l<directives.size();l++){
						SDBDirective dir = (SDBDirective)directives.get(l);
						if(true){//!(i==startIndex[1] && k==startIndex[2] && l==startIndex[3])){
							searchIndex = searchPatternIn(pattern, dir.getDescription()+ nl + dir.getDirectiveString(), startIndex[4], bCaseSensitive, true);
							
							if(searchIndex >= 0){
								setStartIndex(0,i,k,l, searchIndex);
								setStartObject(root,symptom,sol,dir, searchIndex, searchIndex+pattern.length());
								return start;					
							}
							else
							{
								startIndex[4] = -1;
							}
						}
					}
					l = 0;
					
				}
				k = 0;
			}

			setStartObject(null,null,null,null, -1, -1);
			return start;

   }

   private Object[] searchUp(String pattern, boolean bCaseSensitive){
   			int searchIndex = -1;
   			String nl = SymptomDBSearchDialog.getFieldSeparator();   			
   			
			EList symptoms = root.getSymptoms();
			
			for(int i=index[1];i>=0 && i<symptoms.size();i--){
				SDBSymptom symptom = (SDBSymptom)symptoms.get(i);

				EList solutions = symptom.getSolutions();				
				int k=solutions.size()-1;
				
				// a solution is the selected node so begin the new find starting from that element
				// or 
				if(i==index[1] && index[2]>=-1)
					k = index[2];
									
				for(;k>=0 && k<solutions.size();k--){
					
					SDBSolution sol = (SDBSolution)solutions.get(k);

					EList directives = sol.getDirectives();
					int l=directives.size()-1;
					if(i==index[1] && k==index[2] && index[3]>=-1)
						l = index[3];
										
					for(;l>=0 && l<directives.size();l--){
						SDBDirective dir = (SDBDirective)directives.get(l);
						if(!(i==startIndex[1] && k==startIndex[2] && startIndex[3]==-1)){//(i==startIndex[1] && k==startIndex[2] && l==startIndex[3])){
							String searchStr = dir.getDescription() + nl + dir.getDirectiveString();
							
							searchIndex = searchPatternIn(pattern, searchStr, startIndex[4], bCaseSensitive, false);							

							if(searchIndex >= 0){
								setStartIndex(0,i,k,l, searchIndex);
								setStartObject(root,symptom,sol,dir, searchIndex, searchIndex+pattern.length());
								return start;					
							}
							else
							{
								startIndex[4]=-1;
							}
						}
					}
					
					searchIndex = searchPatternIn(pattern, sol.getDescription(), startIndex[4], bCaseSensitive, false); 
					if(searchIndex >= 0){
						setStartIndex(0,i,k,-1, searchIndex);
						setStartObject(root,symptom,sol,null, searchIndex, searchIndex+pattern.length());					    
						return start;
					}
					else
					{
						startIndex[4]=-1;
					}					

										
				}

				String searchStr = symptom.getDescription() + nl;

				String mnl = System.getProperties().getProperty("line.separator");				

				EList patterns = symptom.getPatterns();	
				for(int j=0;j<patterns.size();j++){
					SDBMatchPattern match = (SDBMatchPattern)patterns.get(j);
					searchStr = searchStr + match.getValue() + mnl;//HERE bug 71785
				}

				searchIndex = searchPatternIn(pattern, searchStr, startIndex[4], bCaseSensitive, false);
				if(searchIndex >= 0){
					setStartIndex(0,i,-1,-1, searchIndex);
					setStartObject(root,symptom,null,null, searchIndex, searchIndex+pattern.length());
					return start;					
				}
				else
				{
					startIndex[4]=-1;
				}				
					
			}

			if(true){
				searchIndex = searchPatternIn(pattern, root.getName() + nl + root.getSymptomUrl() + nl + root.getLocalExternalFileLocation() + nl + root.getDescription(),startIndex[4], bCaseSensitive, false);
				if(searchIndex >= 0){
					setStartIndex(0,-1,-1,-1, searchIndex);
					setStartObject(root, null, null, null, searchIndex, searchIndex+pattern.length());
					return start;
				}
				else
				{
					startIndex[4] = -1;
				}				
			}
   
   		 setStartObject(null,null,null,null,-1,-1);
   		 return start;
   }

	
	private void setStartIndex(int i0, int i1, int i2, int i3, int i4){
			
		startIndex[0] = i0;
		startIndex[1] = i1;
		startIndex[2] = i2;
		startIndex[3] = i3;
		startIndex[4] = i4;
	}
	
	private void setIndex(int i0, int i1, int i2, int i3, int i4){
			index[0] = i0;
			index[1] = i1;
			index[2] = i2;
			index[3] = i3;
			index[4] = i4;
	}
	
	private void setStartObject(Object s0, Object s1, Object s2, Object s3, int s4, int s5){

		start[0] = s0;
		start[1] = s1;
		start[2] = s2;
		start[3] = s3;
		start[4] = new Integer(s4);
		start[5] = new Integer(s5);
	
	}
}
