/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SecurityPlugin.java,v 1.9 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SecurityPlugin extends AbstractUIPlugin
{
	private final static String KEYSTORE = "keystore.dat";
	private static SecurityPlugin inst;
	private static ResourceBundle aResourceBundle;
	public static final String PLUGIN_ID = "org.eclipse.hyades.security"; //$NON-NLS-1$

	public SecurityPlugin() {

		//**** cash the Plugin and the resource bundle instances
		if (inst == null)
			inst = this;
	}
	
	public static SecurityPlugin getDefault() {
		return inst;
	}

	public static String getPluginId() {
		return PLUGIN_ID;
	}

	public static ResourceBundle getResourceBundle() {
		if(aResourceBundle == null)
		{
			try {
				aResourceBundle = Platform.getResourceBundle(Platform.getBundle(PLUGIN_ID));
			} catch (Exception e) {
				aResourceBundle = null;
			}
		}
		return aResourceBundle;
	}
	
	public static String getResourceString(String key) {
		try {
			return getResourceBundle().getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	public static String getKeyStoreLocation() {
		
		return Platform.getPluginStateLocation(inst).append(KEYSTORE).toOSString();
	}

	public static String getWorkspaceName(){
		IPath workspace = Platform.getLocation();
		int nr = workspace.segmentCount();
		String workspaceName = workspaceName = workspace.segment(nr - 1);
		return workspaceName;		
	}

	/* (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {

		super.stop(context);
		
		savePluginPreferences();
		SecurityImages.shutdown();
	}

	public static Shell getActiveWorkbenchShell() {
		return getActiveWorkbenchWindow().getShell();
	}
	public static IWorkbenchWindow getActiveWorkbenchWindow() {
		return getDefault().getWorkbench().getActiveWorkbenchWindow();
	}
	
	public void log(IStatus status) {
		getLog().log(status);
	}
	
	public void log(Throwable e) {
		log(new Status(IStatus.ERROR, PLUGIN_ID, IStatus.ERROR, "Error", e)); //$NON-NLS-1$
	}
	
}
