/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConnectivityDialog.java,v 1.8 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security.util;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import org.eclipse.hyades.security.SecurityPlugin;

public class ConnectivityDialog extends Dialog {

    private ConnectivityUI _connectivityUI;
    private String fHost;
    private String fUserId;
    private String fPassword;
    private String fDescription;
    private boolean fSelectUserField=true;
	
	public ConnectivityDialog(Shell shell, String host){
		this(shell, host, "", "", true);
	}
	
	public ConnectivityDialog(Shell shell, String host, String userId){
		this(shell, host, userId, "", true);
	}
	
	public ConnectivityDialog(Shell shell, String host, String userId, boolean selectUserField){
		this(shell, host, userId, "", selectUserField);
	}	

	public ConnectivityDialog(Shell shell, String host, String userId, String password, boolean selectUserField){
		super(shell);
		
		fHost = host;
		fUserId = userId;
		fPassword = password;
		fSelectUserField = selectUserField;
	}
	
	protected Control createDialogArea(Composite parent){ 

		getShell().setText(SecurityPlugin.getResourceString("SEC_MSG"));
		Composite content = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		GridData data = GridUtil.createFill();
		layout.numColumns = 1;
		content.setLayout(layout);
		content.setLayoutData(data);

		_connectivityUI = new ConnectivityUI(getShell());
		_connectivityUI.setUserSelection(fSelectUserField);
		_connectivityUI.setDescription(fDescription);		
		_connectivityUI.createContents(content);
		_connectivityUI.setHost(fHost);
		_connectivityUI.setUserId(fUserId);
		_connectivityUI.setPassword(fPassword);

									
		return content;
	}
	
	protected Control createButtonBar(Composite parent) {
		Control control = super.createButtonBar(parent);
		getShell().setDefaultButton(getButton(IDialogConstants.OK_ID));
		return control;
		
	}
	
	protected void okPressed(){
		
		fUserId = _connectivityUI.getUserId();
		fPassword = _connectivityUI.getPassword();
		
		if(fUserId.equals(""))
		{
			String text = SecurityPlugin.getResourceString("USER_TEXT_ERROR_");
			String info = SecurityPlugin.getResourceString("INVALID_SETTINGS");
			Status err = new Status(Status.WARNING,ResourcesPlugin.PI_RESOURCES,IResourceStatus.WARNING,text,null);			
			ErrorDialog.openError(SecurityPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell()
			                      ,SecurityPlugin.getResourceString("SEC_MSG")
			                      ,info,err);
			
			return;
		}
		if(fPassword.equals(""))
		{
			String text = SecurityPlugin.getResourceString("PWD_TEXT_ERROR_");
			String info = SecurityPlugin.getResourceString("INVALID_SETTINGS");
			Status err = new Status(Status.WARNING,ResourcesPlugin.PI_RESOURCES,IResourceStatus.WARNING,text,null);			
			ErrorDialog.openError(SecurityPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell()
			                      ,SecurityPlugin.getResourceString("SEC_MSG")
			                      ,info,err);
			
			return;
		}
		
		super.okPressed();
	}
	
	public String getUserId()		
	{
		return fUserId;
	}
	
	public String getPassword()
	{
		return fPassword;
	}
	

    public void setDescription(String desc)
    {
    	fDescription = desc;
    }	
}
