/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ImportSecurityCertificatePage.java,v 1.5 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.IWorkbench;

import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.security.SecurityImages;
import org.eclipse.hyades.security.SecurityPlugin;

public class ImportSecurityCertificatePage extends WizardPage implements Listener
{
    private SecurityUI _securityUI;
	
	/**
	 * Constructor for ImportSecurityCertificatePage.
	 * @param name
	 * @param selection
	 */
	public ImportSecurityCertificatePage(
		IWorkbench workbench,
		IStructuredSelection selection) {
		super(SecurityPlugin.getResourceString("STR_IMPORT_SECURITY_WIZARD_PTITLE"));
		setTitle(SecurityPlugin.getResourceString("STR_IMPORT_SECURITY_WIZARD_PTITLE"));
		setDescription(SecurityPlugin.getResourceString("STR_IMPORT_SECURITY_WIZARD_PDESC"));
		setImageDescriptor(
			SecurityImages.getImageDescriptor(SecurityImages.IMG_WZ_IMPORT_CERTIF));
		
	}

	/**
	 * @see org.eclipse.ui.dialogs.WizardImportPage#createSourceGroup(Composite)
	 */
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());
		GridData data = GridUtil.createFill();
		data.widthHint = 300;
		composite.setLayoutData(data);
		composite.setLayoutData(data);
		Shell shell	= getShell();

		_securityUI = new SecurityUI(shell);
		_securityUI.createContents(composite);
        _securityUI.registerListener(this);
		setControl(composite);
		setPageComplete(false);
		
	}
	
	protected boolean determinePageCompletion() {
		boolean complete = _securityUI.validateDialog();

		if (complete)
			setErrorMessage(null);

		return complete;
	}
	
	public boolean finish()
	{	
		String path = _securityUI.getPath();

		String storePath = SecurityPlugin.getKeyStoreLocation();
		String passw = SecurityPlugin.getWorkspaceName();
		
		String exc_msg = "";

		KeyStore ks;

			
		try{	
			ks = getKeyStore();
			_securityUI.loadCertificate(ks);
		}
		catch(FileNotFoundException e){

			String text = SecurityPlugin.getResourceString("STR_KEY_IO_ERROR_");
			text = TString.change(text, "%1", _securityUI.getPath());
			String msg = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
			
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR,text,e);
			ErrorDialog.openError(SecurityPlugin.getActiveWorkbenchShell(),SecurityPlugin.getResourceString("SEC_MSG"), msg,err);
			return false;
			
		}
		catch(IOException e){

			String text = SecurityPlugin.getResourceString("STR_LOAD_IO_EXC_");
			text = TString.change(text, "%1", _securityUI.getPath());

			text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
			String msg = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
			
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR,text,e);
			ErrorDialog.openError(SecurityPlugin.getActiveWorkbenchShell(),SecurityPlugin.getResourceString("SEC_MSG"), msg,err);
			return false;
										
		}
		catch(CertificateException exc){

			String text = SecurityPlugin.getResourceString("STR_CERTIFICATE_EXC_");
			text = TString.change(text, "%1", _securityUI.getPath());
			String msg = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
			
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR,text,exc);
			ErrorDialog.openError(SecurityPlugin.getActiveWorkbenchShell(),SecurityPlugin.getResourceString("SEC_MSG"), msg,err);
			return false;

		}
		catch(KeyStoreException exc){
			String text = SecurityPlugin.getResourceString("STR_KEY_STORE_ERROR_");
			text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
			String msg = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
			
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR,text,exc);
			ErrorDialog.openError(SecurityPlugin.getActiveWorkbenchShell(),SecurityPlugin.getResourceString("SEC_MSG"), msg,err);
			return false;

		}
		catch(NoSuchProviderException exc2){

			String text = SecurityPlugin.getResourceString("STR_SECURITY_PROVIDER_ERROR_");
			text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
			String msg = SecurityPlugin.getResourceString("STR_INITIALIZE_ERROR_");
			msg = TString.change(msg, "%1", SecurityPlugin.getKeyStoreLocation());
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR,text,exc2);
			ErrorDialog.openError(SecurityPlugin.getActiveWorkbenchShell(),SecurityPlugin.getResourceString("SEC_MSG"), msg,err);
			return false;
		
		}
		catch(NoSuchAlgorithmException exc2)
		{
			String text = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
			text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
			String msg = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
			
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR,text,exc2);
			ErrorDialog.openError(SecurityPlugin.getActiveWorkbenchShell(),SecurityPlugin.getResourceString("SEC_MSG"), msg,err);
			return false;
		}
			


		try{
			
			KeystoreHelper.persistKeyStore(ks, storePath, passw);			
		}
		catch(IOException e){

			String text = SecurityPlugin.getResourceString("STR_IO_SAVE_ERROR_");
			text = TString.change(text, "%1", storePath);
			String msg = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
			
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR,text,e);
			ErrorDialog.openError(SecurityPlugin.getActiveWorkbenchShell(),SecurityPlugin.getResourceString("SEC_MSG"), msg,err);
			return false;
										
		}
		catch(CertificateException exc){

			String text = SecurityPlugin.getResourceString("STR_CERTIFICATE_STORE_ERROR_");
			text = TString.change(text, "%1", storePath);
			String msg = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
			
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR,text,exc);
			ErrorDialog.openError(SecurityPlugin.getActiveWorkbenchShell(),SecurityPlugin.getResourceString("SEC_MSG"), msg,err);
			return false;

		}
		catch(KeyStoreException exc){

			String text = SecurityPlugin.getResourceString("STR_UNINIT_KEYSTORE_ERROR_");
			text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
			String msg = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
			
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR,text,exc);
			ErrorDialog.openError(SecurityPlugin.getActiveWorkbenchShell(),SecurityPlugin.getResourceString("SEC_MSG"), msg,err);
			return false;

		}
		catch(NoSuchAlgorithmException exc2)
		{
			String text = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
			text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
			String msg = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
			
			Status err = new Status(Status.ERROR,ResourcesPlugin.PI_RESOURCES,IResourceStatus.ERROR,text,exc2);
			ErrorDialog.openError(SecurityPlugin.getActiveWorkbenchShell(),SecurityPlugin.getResourceString("SEC_MSG"), msg,err);
			return false;
		}
		

		return true;
	}

	public void handleEvent(Event e){
		setPageComplete(determinePageCompletion());
	}

    private KeyStore getKeyStore() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException{
		return KeystoreHelper.createKeyStore(SecurityPlugin.getKeyStoreLocation(), SecurityPlugin.getWorkspaceName());    	
    }
		
}
