/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuiteLocationSelectionPage.java,v 1.4 2005/02/16 22:20:27 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.testgen.ui.wizards;

import org.eclipse.hyades.execution.testgen.TestgenPlugin;


/**
 * Wizard page which prompts the user for the storage location and filename of the generated test 
 * @author Ernest Jessee
 */
public class TestSuiteLocationSelectionPage extends FileLocationSelectionWizardpage
{
	
	
	
	public String getDescription()
	{
		return TestgenPlugin.getResourceString("SELECT_SUITE_LOCATION_WIZARDPAGE_DESCRIPTION"); //$NON-NLS-1$
	}

	public String getFileExtension()
	{
		return "testsuite"; //$NON-NLS-1$
	}

	public String getFileNameLabel()
	{
		return TestgenPlugin.getResourceString("TestSuiteLocationSelectionPage.TEST_FILENAME_CONTROL_LABEL"); //$NON-NLS-1$
	}

	public String getPreferenceID()
	{
		return null;
	}

	public String getTitle()
	{
		return TestgenPlugin.getResourceString("TEST_GENERATION_WIZARD_TITLE"); //$NON-NLS-1$
	}

	public String getContextHelpID()
	{
		return "org.eclipse.hyades.execution.testgen.TestSuitePathSelector"; //$NON-NLS-1$
	}

}
