/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLagentDestroyLoader.java,v 1.9 2005/02/16 22:21:22 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;


public class XMLagentDestroyLoader extends IgnoredXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    private String agentIdRef;
    private double time;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        if (name.equals("agentIdRef")) {
            agentIdRef = value;
        } else if (name.equals("time")) {
            time = Double.valueOf(value).doubleValue();
        }
    }

    public void addYourselfInContext() {
    	if(agentIdRef!=null && time!=0)
    	{
			TRCAgent agent = LoadersUtils.locateAgent(agentIdRef,context.getAgent());
			if(agent!=null)
			{
				agent.setStopTime(time);
				agent.getAgentProxy().setStopTime(time);
			}
    	}
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        agentIdRef = null;
        time = 0;
    }
}
