/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HierarchyXMLLoadersFactory.java,v 1.7 2005/03/16 19:35:58 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.hyades.loaders.hierarchy.XMLAGENT_CREATELoader;
import org.eclipse.hyades.loaders.hierarchy.XMLNODE_CREATELoader;
import org.eclipse.hyades.loaders.hierarchy.XMLPROCESS_CREATELoader;
import org.eclipse.hyades.loaders.hierarchy.XMLagentDestroyLoader;
import org.eclipse.hyades.loaders.hierarchy.XMLfilterLoader;
import org.eclipse.hyades.loaders.hierarchy.XMLoptionLoader;


public class HierarchyXMLLoadersFactory implements XMLFragmentLoadersFactory {
    //~ Methods ------------------------------------------------------------------------------------

    public String getLoaderClassName(String elementName) {
        if (elementName.equals("option")) {
            return XMLoptionLoader.class.getName();
        }

        if (elementName.equals("filter")) {
            return XMLfilterLoader.class.getName();
        }

        if (elementName.equals("agentDestroy")) {
            return XMLagentDestroyLoader.class.getName();
        }

        if (elementName.equals("NODE")) {
            return XMLNODE_CREATELoader.class.getName();
        }

        if (elementName.equals("PROCESS_CREATE")) {
            return XMLPROCESS_CREATELoader.class.getName();
        }

        if (elementName.equals("AGENT_CREATE")) {
            return XMLAGENT_CREATELoader.class.getName();
        }

        return null;
    }

    public Set getSupportedElements() {
        Set set = new HashSet();

        set.add("option");
        set.add("filter");
        set.add("agentDestroy");
        set.add("NODE");
        set.add("PROCESS_CREATE");
        set.add("AGENT_CREATE");

        return set;
    }
}
