/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IXMLLoader.java,v 1.3 2005/02/16 22:21:22 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;


/**
 * @author slavescu
 */
public interface IXMLLoader {
    //~ Methods ------------------------------------------------------------------------------------

    public abstract void setCollectionMode(int collectionMode);

    public abstract HierarchyContext getContext();

    public abstract int getProcessedFragments();

    public abstract void attributeName(String name);

    public abstract void attributeValueCharacters(String attributeValue);

    public abstract void characters(char[] ch, int start, int length);

    public abstract void cleanUp();

    public abstract void endDocument(Object object, int i);

    public abstract void endElement(String elementName, int currentOffset);

    public abstract void error(InvalidXMLException exception);

    public abstract void loadEvent(byte[] buffer, int length, boolean loadToModel, boolean toProfileFile) throws InvalidXMLException;

    public abstract void loadEvent(byte[] buffer, int length, boolean loadToModel) throws InvalidXMLException;

    public abstract void loadEvent(byte[] buffer, int length) throws InvalidXMLException;

    public abstract void restartParser();

    public abstract void startDocument();

    public abstract void startElement(String elementName, boolean hasAttributes, boolean isEmpty);
}
