/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InvalidXMLException.java,v 1.4 2005/02/16 22:21:22 qiyanli Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.loaders.util;
import java.io.PrintStream;
import java.io.PrintWriter;
public class InvalidXMLException extends RuntimeException {
	//~ Instance fields
	// ----------------------------------------------------------------------------
	private Exception enclosedException;
	//~ Constructors
	// -------------------------------------------------------------------------------
	/**
	 * Constructor for InvalidXMLException
	 */
	public InvalidXMLException() {
		super();
	}
	/**
	 * @param arg0
	 */
	public InvalidXMLException(Exception e) {
		super(e.getLocalizedMessage());
		enclosedException = e;
	}
	//~ Methods
	// ------------------------------------------------------------------------------------
	/**
	 * @return Exception
	 */
	public Exception getEnclosedException() {
		return enclosedException;
	}
	public void printStackTrace() {
		printStackTrace1(System.err);
	}
	public void printStackTrace(java.io.PrintStream s) {
		printStackTrace1(s);
	}
	public void printStackTrace(java.io.PrintWriter s) {
		printStackTrace1(s);
	}
	public void printStackTrace1(Object s) {
		if (s instanceof PrintStream)
			if (enclosedException == null)
				super.printStackTrace((PrintStream) s);
			else
				enclosedException.printStackTrace((PrintStream) s);
		else if (s instanceof PrintWriter)
			if (enclosedException == null)
				super.printStackTrace((PrintWriter) s);
			else
				enclosedException.printStackTrace((PrintWriter) s);
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Throwable#getLocalizedMessage()
	 */
	public String getLocalizedMessage() {
		if(enclosedException!=null)
			return enclosedException.getLocalizedMessage();
		return super.getLocalizedMessage();
	}
	/* (non-Javadoc)
	 * @see java.lang.Throwable#getMessage()
	 */
	public String getMessage() {
		if(enclosedException!=null)
			return enclosedException.getMessage();
		return super.getMessage();
	}
	public Throwable getCause() {
		if(enclosedException!=null)
			return enclosedException.getCause();
		return super.getCause();
	}
	public StackTraceElement[] getStackTrace() {
		if(enclosedException!=null)
			return enclosedException.getStackTrace();
		return super.getStackTrace();
	}
	public String toString() {
		if(enclosedException!=null)
			return enclosedException.toString();
		return super.toString();
	}
}