/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LookupService.java,v 1.5 2005/02/16 22:21:22 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.util.Set;


/**
 * @author slavescu
 */
public interface LookupService {
    //~ Methods ------------------------------------------------------------------------------------

    Set getSupportedTypes();

    boolean deregister(HierarchyContext context, Class type, Object key);

    boolean deregister(HierarchyContext context, Object value);

	boolean deregister(HierarchyContext context, Class type);

	boolean deregister(HierarchyContext context);

    Object locate(HierarchyContext context, Object key);

    Object locate(HierarchyContext context, Class type, Object key);

    boolean register(HierarchyContext context, Object value);
}
