/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLFragmentHandlerExtensions.java,v 1.3 2005/02/16 22:21:22 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.util.HashMap;


/**
 * @author slavescu
 */
public class XMLFragmentHandlerExtensions extends HashMap {
    //~ Static fields/initializers -----------------------------------------------------------------

    private static XMLFragmentHandlerExtensions instance;

    //~ Constructors -------------------------------------------------------------------------------

    private XMLFragmentHandlerExtensions() {
        super();
    }

    //~ Methods ------------------------------------------------------------------------------------

    public static XMLFragmentHandlerExtensions getInstance() {
        if (instance == null) {
            instance = new XMLFragmentHandlerExtensions();
            new XMLFragmentHandlerRegistryReader().readRegistry();
        }

        return instance;
    }
}


/**
 * A plugin extension reader that populates the
 * loaders registry.
 * Clients are not expected to use this class directly.
 */
class XMLFragmentHandlerRegistryReader extends RegistryReader {
    //~ Static fields/initializers -----------------------------------------------------------------

    static final String TAG_HANDLER = "handler";
    static final String ATT_CLASS = "class";

    //~ Constructors -------------------------------------------------------------------------------

    public XMLFragmentHandlerRegistryReader() {
        super(RegistryReader.HANDLER_PPID);
    }

    //~ Methods ------------------------------------------------------------------------------------

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_HANDLER)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                logMissingAttribute(element, ATT_CLASS);
            } else {
                if (XMLFragmentHandlerExtensions.getInstance().size() > 0) {
                    logError(element, "Another handler has been already registered. Only the first registered XML handler would be active.");
                } else {
                    try {
                        IHyadesPluginClassDescriptor classDescriptor = createPluginClassDescriptor(element, ATT_CLASS);

                        XMLFragmentHandlerExtensions.getInstance().put(TAG_HANDLER, (XMLFragmentHandler) classDescriptor.createInstance());
                    } catch (Exception e) {
                        logError(element, e.getLocalizedMessage());
                    }

                    return true;
                }
            }
        }

        return false;
    }
}
