/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: AbstractTRCCollectionBoundary.java,v 1.19 2005/03/16 19:07:50 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Abstract TRC Collection Boundary</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class allows for a clean plugin dependency packaging. Hyades needs to allow different plugins for each model sub-package in order to avoid all of them having to always be present and possibly loaded.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getCollectionMode <em>Collection Mode</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getConfiguration <em>Configuration</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getAbstractTRCCollectionBoundary()
 * @model abstract="true"
 * @generated
 */
public interface AbstractTRCCollectionBoundary extends EObject{
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getAbstractTRCCollectionBoundary_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Start Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The creation time of this object, relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Start Time</em>' attribute.
	 * @see #setStartTime(double)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getAbstractTRCCollectionBoundary_StartTime()
	 * @model 
	 * @generated
	 */
	double getStartTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getStartTime <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start Time</em>' attribute.
	 * @see #getStartTime()
	 * @generated
	 */
	void setStartTime(double value);

	/**
	 * Returns the value of the '<em><b>Collection Mode</b></em>' attribute.
	 * The default value is <code>"HEAP_STATISTICS_ONLY"</code>.
	 * The literals are from the enumeration {@link org.eclipse.hyades.models.hierarchy.TRCCollectionMode}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Collection Mode</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Defines different collection modes (some include filtering of data on agent side some on loader side and some are combined). This is used by loaders and UI to decide the model building algorithms and the presentation mode.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Collection Mode</em>' attribute.
	 * @see org.eclipse.hyades.models.hierarchy.TRCCollectionMode
	 * @see #setCollectionMode(TRCCollectionMode)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getAbstractTRCCollectionBoundary_CollectionMode()
	 * @model default="HEAP_STATISTICS_ONLY"
	 * @generated
	 */
	TRCCollectionMode getCollectionMode();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getCollectionMode <em>Collection Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Collection Mode</em>' attribute.
	 * @see org.eclipse.hyades.models.hierarchy.TRCCollectionMode
	 * @see #getCollectionMode()
	 * @generated
	 */
	void setCollectionMode(TRCCollectionMode value);

	/**
	 * Returns the value of the '<em><b>Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Configuration</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Configuration</em>' reference.
	 * @see #setConfiguration(TRCConfiguration)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getAbstractTRCCollectionBoundary_Configuration()
	 * @model 
	 * @generated
	 */
	TRCConfiguration getConfiguration();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getConfiguration <em>Configuration</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Configuration</em>' reference.
	 * @see #getConfiguration()
	 * @generated
	 */
	void setConfiguration(TRCConfiguration value);

} // AbstractTRCCollectionBoundary
