/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: Query.java,v 1.15 2005/03/16 19:07:50 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Query</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getSources <em>Sources</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#isDistinct <em>Distinct</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#isCount <em>Count</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getOutputElements <em>Output Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getSubQuery <em>Sub Query</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getQuery <em>Query</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery()
 * @model abstract="true"
 * @generated
 */
public interface Query extends EObject{
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Sources</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Points to a list of resource URIs, starting EObject URIs or Query names
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Sources</em>' attribute list.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_Sources()
	 * @model type="java.lang.String"
	 * @generated
	 */
	EList getSources();

	/**
	 * Returns the value of the '<em><b>Distinct</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Distinct</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Distinct</em>' attribute.
	 * @see #setDistinct(boolean)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_Distinct()
	 * @model 
	 * @generated
	 */
	boolean isDistinct();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#isDistinct <em>Distinct</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Distinct</em>' attribute.
	 * @see #isDistinct()
	 * @generated
	 */
	void setDistinct(boolean value);

	/**
	 * Returns the value of the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Count</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Count</em>' attribute.
	 * @see #setCount(boolean)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_Count()
	 * @model 
	 * @generated
	 */
	boolean isCount();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#isCount <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Count</em>' attribute.
	 * @see #isCount()
	 * @generated
	 */
	void setCount(boolean value);

	/**
	 * Returns the value of the '<em><b>Output Elements</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.extensions.Operand}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.extensions.Operand#getQuery <em>Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Output Elements</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Output Elements</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_OutputElements()
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Operand#getQuery
	 * @model type="org.eclipse.hyades.models.hierarchy.extensions.Operand" opposite="query" containment="true"
	 * @generated
	 */
	EList getOutputElements();

	/**
	 * Returns the value of the '<em><b>Sub Query</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.extensions.Query}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getQuery <em>Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sub Query</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sub Query</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_SubQuery()
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getQuery
	 * @model type="org.eclipse.hyades.models.hierarchy.extensions.Query" opposite="query" containment="true"
	 * @generated
	 */
	EList getSubQuery();

	/**
	 * Returns the value of the '<em><b>Query</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getSubQuery <em>Sub Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Query</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Query</em>' container reference.
	 * @see #setQuery(Query)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getQuery_Query()
	 * @see org.eclipse.hyades.models.hierarchy.extensions.Query#getSubQuery
	 * @model opposite="subQuery"
	 * @generated
	 */
	Query getQuery();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.Query#getQuery <em>Query</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Query</em>' container reference.
	 * @see #getQuery()
	 * @generated
	 */
	void setQuery(Query value);

} // Query
