/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: SimpleSearchQuery.java,v 1.15 2005/03/16 19:07:50 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Simple Search Query</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getMaxElements <em>Max Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getStartWith <em>Start With</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getOrderByExpresions <em>Order By Expresions</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getWhereExpression <em>Where Expression</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getSimpleSearchQuery()
 * @model 
 * @generated
 */
public interface SimpleSearchQuery extends Query{
	/**
	 * Returns the value of the '<em><b>Max Elements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Maximum number of returned elements.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Max Elements</em>' attribute.
	 * @see #setMaxElements(int)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getSimpleSearchQuery_MaxElements()
	 * @model 
	 * @generated
	 */
	int getMaxElements();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getMaxElements <em>Max Elements</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Max Elements</em>' attribute.
	 * @see #getMaxElements()
	 * @generated
	 */
	void setMaxElements(int value);

	/**
	 * Returns the value of the '<em><b>Start With</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The starting index in the result set from where we will return the values, if negative it will be relative to the end of the result set.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Start With</em>' attribute.
	 * @see #setStartWith(int)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getSimpleSearchQuery_StartWith()
	 * @model 
	 * @generated
	 */
	int getStartWith();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getStartWith <em>Start With</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start With</em>' attribute.
	 * @see #getStartWith()
	 * @generated
	 */
	void setStartWith(int value);

	/**
	 * Returns the value of the '<em><b>Order By Expresions</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.extensions.OrderByElement}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getSearchQuery <em>Search Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Order By Expresions</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Order By Expresions</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getSimpleSearchQuery_OrderByExpresions()
	 * @see org.eclipse.hyades.models.hierarchy.extensions.OrderByElement#getSearchQuery
	 * @model type="org.eclipse.hyades.models.hierarchy.extensions.OrderByElement" opposite="searchQuery" containment="true"
	 * @generated
	 */
	EList getOrderByExpresions();

	/**
	 * Returns the value of the '<em><b>Where Expression</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.extensions.WhereExpression#getSearchQuery <em>Search Query</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Where Expression</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Where Expression</em>' containment reference.
	 * @see #setWhereExpression(WhereExpression)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getSimpleSearchQuery_WhereExpression()
	 * @see org.eclipse.hyades.models.hierarchy.extensions.WhereExpression#getSearchQuery
	 * @model opposite="searchQuery" containment="true"
	 * @generated
	 */
	WhereExpression getWhereExpression();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getWhereExpression <em>Where Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Where Expression</em>' containment reference.
	 * @see #getWhereExpression()
	 * @generated
	 */
	void setWhereExpression(WhereExpression value);

} // SimpleSearchQuery
