/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BinaryExpressionImpl.java,v 1.9 2005/03/16 19:35:58 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Binary Expression</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.BinaryExpressionImpl#getOperator <em>Operator</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.BinaryExpressionImpl#getLeftOperand <em>Left Operand</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.BinaryExpressionImpl#getRightOperands <em>Right Operands</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.BinaryExpressionImpl#isCaseInsensitive <em>Case Insensitive</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.BinaryExpressionImpl#getInstanceQuery <em>Instance Query</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BinaryExpressionImpl extends WhereExpressionImpl implements BinaryExpression {
	/**
	 * The default value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected static final RelationalOperators OPERATOR_EDEFAULT = RelationalOperators.LT_LITERAL;

	/**
	 * The cached value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected RelationalOperators operator = OPERATOR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getLeftOperand() <em>Left Operand</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLeftOperand()
	 * @generated
	 * @ordered
	 */
	protected Operand leftOperand = null;

	/**
	 * The cached value of the '{@link #getRightOperands() <em>Right Operands</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRightOperands()
	 * @generated
	 * @ordered
	 */
	protected EList rightOperands = null;

	/**
	 * The default value of the '{@link #isCaseInsensitive() <em>Case Insensitive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isCaseInsensitive()
	 * @generated
	 * @ordered
	 */
	protected static final boolean CASE_INSENSITIVE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isCaseInsensitive() <em>Case Insensitive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isCaseInsensitive()
	 * @generated
	 * @ordered
	 */
	protected boolean caseInsensitive = CASE_INSENSITIVE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BinaryExpressionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ExtensionsPackage.eINSTANCE.getBinaryExpression();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RelationalOperators getOperator() {
		return operator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperator(RelationalOperators newOperator) {
		RelationalOperators oldOperator = operator;
		operator = newOperator == null ? OPERATOR_EDEFAULT : newOperator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.BINARY_EXPRESSION__OPERATOR, oldOperator, operator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Operand getLeftOperand() {
		return leftOperand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLeftOperand(Operand newLeftOperand, NotificationChain msgs) {
		Operand oldLeftOperand = leftOperand;
		leftOperand = newLeftOperand;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ExtensionsPackage.BINARY_EXPRESSION__LEFT_OPERAND, oldLeftOperand, newLeftOperand);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLeftOperand(Operand newLeftOperand) {
		if (newLeftOperand != leftOperand) {
			NotificationChain msgs = null;
			if (leftOperand != null)
				msgs = ((InternalEObject)leftOperand).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ExtensionsPackage.BINARY_EXPRESSION__LEFT_OPERAND, null, msgs);
			if (newLeftOperand != null)
				msgs = ((InternalEObject)newLeftOperand).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ExtensionsPackage.BINARY_EXPRESSION__LEFT_OPERAND, null, msgs);
			msgs = basicSetLeftOperand(newLeftOperand, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.BINARY_EXPRESSION__LEFT_OPERAND, newLeftOperand, newLeftOperand));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRightOperands() {
		if (rightOperands == null) {
			rightOperands = new EObjectContainmentEList(Operand.class, this, ExtensionsPackage.BINARY_EXPRESSION__RIGHT_OPERANDS);
		}
		return rightOperands;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isCaseInsensitive() {
		return caseInsensitive;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCaseInsensitive(boolean newCaseInsensitive) {
		boolean oldCaseInsensitive = caseInsensitive;
		caseInsensitive = newCaseInsensitive;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.BINARY_EXPRESSION__CASE_INSENSITIVE, oldCaseInsensitive, caseInsensitive));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InstanceQuery getInstanceQuery() {
		if (eContainerFeatureID != ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY) return null;
		return (InstanceQuery)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInstanceQuery(InstanceQuery newInstanceQuery) {
		if (newInstanceQuery != eContainer || (eContainerFeatureID != ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY && newInstanceQuery != null)) {
			if (EcoreUtil.isAncestor(this, newInstanceQuery))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newInstanceQuery != null)
				msgs = ((InternalEObject)newInstanceQuery).eInverseAdd(this, ExtensionsPackage.INSTANCE_QUERY__CONDITIONS, InstanceQuery.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newInstanceQuery, ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY, newInstanceQuery, newInstanceQuery));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.BINARY_EXPRESSION__SEARCH_QUERY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, ExtensionsPackage.BINARY_EXPRESSION__SEARCH_QUERY, msgs);
				case ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.BINARY_EXPRESSION__SEARCH_QUERY:
					return eBasicSetContainer(null, ExtensionsPackage.BINARY_EXPRESSION__SEARCH_QUERY, msgs);
				case ExtensionsPackage.BINARY_EXPRESSION__LEFT_OPERAND:
					return basicSetLeftOperand(null, msgs);
				case ExtensionsPackage.BINARY_EXPRESSION__RIGHT_OPERANDS:
					return ((InternalEList)getRightOperands()).basicRemove(otherEnd, msgs);
				case ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY:
					return eBasicSetContainer(null, ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case ExtensionsPackage.BINARY_EXPRESSION__SEARCH_QUERY:
					return ((InternalEObject)eContainer).eInverseRemove(this, ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSION, SimpleSearchQuery.class, msgs);
				case ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY:
					return ((InternalEObject)eContainer).eInverseRemove(this, ExtensionsPackage.INSTANCE_QUERY__CONDITIONS, InstanceQuery.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.BINARY_EXPRESSION__NAME:
				return getName();
			case ExtensionsPackage.BINARY_EXPRESSION__SEARCH_QUERY:
				return getSearchQuery();
			case ExtensionsPackage.BINARY_EXPRESSION__OPERATOR:
				return getOperator();
			case ExtensionsPackage.BINARY_EXPRESSION__LEFT_OPERAND:
				return getLeftOperand();
			case ExtensionsPackage.BINARY_EXPRESSION__RIGHT_OPERANDS:
				return getRightOperands();
			case ExtensionsPackage.BINARY_EXPRESSION__CASE_INSENSITIVE:
				return isCaseInsensitive() ? Boolean.TRUE : Boolean.FALSE;
			case ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY:
				return getInstanceQuery();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.BINARY_EXPRESSION__NAME:
				setName((String)newValue);
				return;
			case ExtensionsPackage.BINARY_EXPRESSION__SEARCH_QUERY:
				setSearchQuery((SimpleSearchQuery)newValue);
				return;
			case ExtensionsPackage.BINARY_EXPRESSION__OPERATOR:
				setOperator((RelationalOperators)newValue);
				return;
			case ExtensionsPackage.BINARY_EXPRESSION__LEFT_OPERAND:
				setLeftOperand((Operand)newValue);
				return;
			case ExtensionsPackage.BINARY_EXPRESSION__RIGHT_OPERANDS:
				getRightOperands().clear();
				getRightOperands().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.BINARY_EXPRESSION__CASE_INSENSITIVE:
				setCaseInsensitive(((Boolean)newValue).booleanValue());
				return;
			case ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY:
				setInstanceQuery((InstanceQuery)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.BINARY_EXPRESSION__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ExtensionsPackage.BINARY_EXPRESSION__SEARCH_QUERY:
				setSearchQuery((SimpleSearchQuery)null);
				return;
			case ExtensionsPackage.BINARY_EXPRESSION__OPERATOR:
				setOperator(OPERATOR_EDEFAULT);
				return;
			case ExtensionsPackage.BINARY_EXPRESSION__LEFT_OPERAND:
				setLeftOperand((Operand)null);
				return;
			case ExtensionsPackage.BINARY_EXPRESSION__RIGHT_OPERANDS:
				getRightOperands().clear();
				return;
			case ExtensionsPackage.BINARY_EXPRESSION__CASE_INSENSITIVE:
				setCaseInsensitive(CASE_INSENSITIVE_EDEFAULT);
				return;
			case ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY:
				setInstanceQuery((InstanceQuery)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.BINARY_EXPRESSION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ExtensionsPackage.BINARY_EXPRESSION__SEARCH_QUERY:
				return getSearchQuery() != null;
			case ExtensionsPackage.BINARY_EXPRESSION__OPERATOR:
				return operator != OPERATOR_EDEFAULT;
			case ExtensionsPackage.BINARY_EXPRESSION__LEFT_OPERAND:
				return leftOperand != null;
			case ExtensionsPackage.BINARY_EXPRESSION__RIGHT_OPERANDS:
				return rightOperands != null && !rightOperands.isEmpty();
			case ExtensionsPackage.BINARY_EXPRESSION__CASE_INSENSITIVE:
				return caseInsensitive != CASE_INSENSITIVE_EDEFAULT;
			case ExtensionsPackage.BINARY_EXPRESSION__INSTANCE_QUERY:
				return getInstanceQuery() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (operator: ");
		result.append(operator);
		result.append(", caseInsensitive: ");
		result.append(caseInsensitive);
		result.append(')');
		return result.toString();
	}

} //BinaryExpressionImpl
