/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ExtensionsFactoryImpl.java,v 1.17 2005/03/16 19:35:58 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ArithmeticOperators;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.NumericFunction;
import org.eclipse.hyades.models.hierarchy.extensions.NumericFunctions;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ExtensionsFactoryImpl extends EFactoryImpl implements ExtensionsFactory {
	/**
	 * Creates and instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExtensionsFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY: return createSimpleSearchQuery();
			case ExtensionsPackage.INSTANCE_QUERY: return createInstanceQuery();
			case ExtensionsPackage.ORDER_BY_ELEMENT: return createOrderByElement();
			case ExtensionsPackage.QUERY_RESULT: return createQueryResult();
			case ExtensionsPackage.BINARY_EXPRESSION: return createBinaryExpression();
			case ExtensionsPackage.RESULT_ENTRY: return createResultEntry();
			case ExtensionsPackage.TIME_BASED_CORRELATION_QUERY: return createTimeBasedCorrelationQuery();
			case ExtensionsPackage.LOGICAL_EXPRESSION: return createLogicalExpression();
			case ExtensionsPackage.WHERE_EXPRESSION: return createWhereExpression();
			case ExtensionsPackage.ARITHMETIC_EXPRESSION: return createArithmeticExpression();
			case ExtensionsPackage.NUMERIC_FUNCTION: return createNumericFunction();
			case ExtensionsPackage.SIMPLE_OPERAND: return createSimpleOperand();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case ExtensionsPackage.RELATIONAL_OPERATORS: {
				RelationalOperators result = RelationalOperators.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case ExtensionsPackage.ORDER_BY_OPERATORS: {
				OrderByOperators result = OrderByOperators.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case ExtensionsPackage.LOGICAL_OPERATORS: {
				LogicalOperators result = LogicalOperators.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case ExtensionsPackage.ARITHMETIC_OPERATORS: {
				ArithmeticOperators result = ArithmeticOperators.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case ExtensionsPackage.NUMERIC_FUNCTIONS: {
				NumericFunctions result = NumericFunctions.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case ExtensionsPackage.RELATIONAL_OPERATORS:
				return instanceValue == null ? null : instanceValue.toString();
			case ExtensionsPackage.ORDER_BY_OPERATORS:
				return instanceValue == null ? null : instanceValue.toString();
			case ExtensionsPackage.LOGICAL_OPERATORS:
				return instanceValue == null ? null : instanceValue.toString();
			case ExtensionsPackage.ARITHMETIC_OPERATORS:
				return instanceValue == null ? null : instanceValue.toString();
			case ExtensionsPackage.NUMERIC_FUNCTIONS:
				return instanceValue == null ? null : instanceValue.toString();
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SimpleSearchQuery createSimpleSearchQuery() {
		SimpleSearchQueryImpl simpleSearchQuery = new SimpleSearchQueryImpl();
		return simpleSearchQuery;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public InstanceQuery createInstanceQuery() {
		InstanceQueryImpl instanceQuery = new InstanceQueryImpl();
		return instanceQuery;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrderByElement createOrderByElement() {
		OrderByElementImpl orderByElement = new OrderByElementImpl();
		return orderByElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QueryResult createQueryResult() {
		QueryResultImpl queryResult = new QueryResultImpl();
		return queryResult;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BinaryExpression createBinaryExpression() {
		BinaryExpressionImpl binaryExpression = new BinaryExpressionImpl();
		return binaryExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResultEntry createResultEntry() {
		ResultEntryImpl resultEntry = new ResultEntryImpl();
		return resultEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TimeBasedCorrelationQuery createTimeBasedCorrelationQuery() {
		TimeBasedCorrelationQueryImpl timeBasedCorrelationQuery = new TimeBasedCorrelationQueryImpl();
		return timeBasedCorrelationQuery;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LogicalExpression createLogicalExpression() {
		LogicalExpressionImpl logicalExpression = new LogicalExpressionImpl();
		return logicalExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public WhereExpression createWhereExpression() {
		WhereExpressionImpl whereExpression = new WhereExpressionImpl();
		return whereExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArithmeticExpression createArithmeticExpression() {
		ArithmeticExpressionImpl arithmeticExpression = new ArithmeticExpressionImpl();
		return arithmeticExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NumericFunction createNumericFunction() {
		NumericFunctionImpl numericFunction = new NumericFunctionImpl();
		return numericFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SimpleOperand createSimpleOperand() {
		SimpleOperandImpl simpleOperand = new SimpleOperandImpl();
		return simpleOperand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExtensionsPackage getExtensionsPackage() {
		return (ExtensionsPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static ExtensionsPackage getPackage() {
		return ExtensionsPackage.eINSTANCE;
	}

} //ExtensionsFactoryImpl
