/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: SimpleOperandImpl.java,v 1.3 2005/03/24 16:28:48 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Simple Operand</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleOperandImpl#getRawValue <em>Raw Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleOperandImpl#getValue <em>Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleOperandImpl#getFeature <em>Feature</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleOperandImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleOperandImpl#getValueType <em>Value Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SimpleOperandImpl extends OperandImpl implements SimpleOperand {
	/**
	 * The default value of the '{@link #getRawValue() <em>Raw Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRawValue()
	 * @generated
	 * @ordered
	 */
	protected static final String RAW_VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRawValue() <em>Raw Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRawValue()
	 * @generated
	 * @ordered
	 */
	protected String rawValue = RAW_VALUE_EDEFAULT;

	/**
	 * The default value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected static final Object VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFeature() <em>Feature</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFeature()
	 * @generated
	 * @ordered
	 */
	protected EStructuralFeature feature = null;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected EClass type = null;

	/**
	 * The cached value of the '{@link #getValueType() <em>Value Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValueType()
	 * @generated
	 * @ordered
	 */
	protected EDataType valueType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SimpleOperandImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ExtensionsPackage.eINSTANCE.getSimpleOperand();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getRawValue() {
		return rawValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRawValue(String newRawValue) {
		String oldRawValue = rawValue;
		rawValue = newRawValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_OPERAND__RAW_VALUE, oldRawValue, rawValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Object getValue() {
		if(getValueType()!=null)
		    return EcoreUtil.createFromString(getValueType(), getRawValue());
		else 
			return getRawValue();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setValue(Object newValue) {
		if(getValueType()!=null)
			setRawValue(EcoreUtil.convertToString(getValueType(), newValue));
		else if(newValue !=null)
			setRawValue(newValue.toString());
		else
			setRawValue(RAW_VALUE_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EStructuralFeature getFeature() {
		if (feature != null && feature.eIsProxy()) {
			EStructuralFeature oldFeature = feature;
			feature = (EStructuralFeature)eResolveProxy((InternalEObject)feature);
			if (feature != oldFeature) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ExtensionsPackage.SIMPLE_OPERAND__FEATURE, oldFeature, feature));
			}
		}
		return feature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EStructuralFeature basicGetFeature() {
		return feature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFeature(EStructuralFeature newFeature) {
		EStructuralFeature oldFeature = feature;
		feature = newFeature;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_OPERAND__FEATURE, oldFeature, feature));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getType() {
		if (type != null && type.eIsProxy()) {
			EClass oldType = type;
			type = (EClass)eResolveProxy((InternalEObject)type);
			if (type != oldType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ExtensionsPackage.SIMPLE_OPERAND__TYPE, oldType, type));
			}
		}
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass basicGetType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(EClass newType) {
		EClass oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_OPERAND__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getValueType() {
		if (valueType != null && valueType.eIsProxy()) {
			EDataType oldValueType = valueType;
			valueType = (EDataType)eResolveProxy((InternalEObject)valueType);
			if (valueType != oldValueType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ExtensionsPackage.SIMPLE_OPERAND__VALUE_TYPE, oldValueType, valueType));
			}
		}
		return valueType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType basicGetValueType() {
		return valueType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValueType(EDataType newValueType) {
		EDataType oldValueType = valueType;
		valueType = newValueType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_OPERAND__VALUE_TYPE, oldValueType, valueType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.SIMPLE_OPERAND__QUERY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, ExtensionsPackage.SIMPLE_OPERAND__QUERY, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.SIMPLE_OPERAND__QUERY:
					return eBasicSetContainer(null, ExtensionsPackage.SIMPLE_OPERAND__QUERY, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case ExtensionsPackage.SIMPLE_OPERAND__QUERY:
					return ((InternalEObject)eContainer).eInverseRemove(this, ExtensionsPackage.QUERY__OUTPUT_ELEMENTS, Query.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.SIMPLE_OPERAND__NAME:
				return getName();
			case ExtensionsPackage.SIMPLE_OPERAND__QUERY:
				return getQuery();
			case ExtensionsPackage.SIMPLE_OPERAND__RAW_VALUE:
				return getRawValue();
			case ExtensionsPackage.SIMPLE_OPERAND__VALUE:
				return getValue();
			case ExtensionsPackage.SIMPLE_OPERAND__FEATURE:
				if (resolve) return getFeature();
				return basicGetFeature();
			case ExtensionsPackage.SIMPLE_OPERAND__TYPE:
				if (resolve) return getType();
				return basicGetType();
			case ExtensionsPackage.SIMPLE_OPERAND__VALUE_TYPE:
				if (resolve) return getValueType();
				return basicGetValueType();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.SIMPLE_OPERAND__NAME:
				setName((String)newValue);
				return;
			case ExtensionsPackage.SIMPLE_OPERAND__QUERY:
				setQuery((Query)newValue);
				return;
			case ExtensionsPackage.SIMPLE_OPERAND__RAW_VALUE:
				setRawValue((String)newValue);
				return;
			case ExtensionsPackage.SIMPLE_OPERAND__VALUE:
				setValue((Object)newValue);
				return;
			case ExtensionsPackage.SIMPLE_OPERAND__FEATURE:
				setFeature((EStructuralFeature)newValue);
				return;
			case ExtensionsPackage.SIMPLE_OPERAND__TYPE:
				setType((EClass)newValue);
				return;
			case ExtensionsPackage.SIMPLE_OPERAND__VALUE_TYPE:
				setValueType((EDataType)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.SIMPLE_OPERAND__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ExtensionsPackage.SIMPLE_OPERAND__QUERY:
				setQuery((Query)null);
				return;
			case ExtensionsPackage.SIMPLE_OPERAND__RAW_VALUE:
				setRawValue(RAW_VALUE_EDEFAULT);
				return;
			case ExtensionsPackage.SIMPLE_OPERAND__VALUE:
				setValue(VALUE_EDEFAULT);
				return;
			case ExtensionsPackage.SIMPLE_OPERAND__FEATURE:
				setFeature((EStructuralFeature)null);
				return;
			case ExtensionsPackage.SIMPLE_OPERAND__TYPE:
				setType((EClass)null);
				return;
			case ExtensionsPackage.SIMPLE_OPERAND__VALUE_TYPE:
				setValueType((EDataType)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.SIMPLE_OPERAND__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ExtensionsPackage.SIMPLE_OPERAND__QUERY:
				return getQuery() != null;
			case ExtensionsPackage.SIMPLE_OPERAND__RAW_VALUE:
				return RAW_VALUE_EDEFAULT == null ? rawValue != null : !RAW_VALUE_EDEFAULT.equals(rawValue);
			case ExtensionsPackage.SIMPLE_OPERAND__VALUE:
				return VALUE_EDEFAULT == null ? getValue() != null : !VALUE_EDEFAULT.equals(getValue());
			case ExtensionsPackage.SIMPLE_OPERAND__FEATURE:
				return feature != null;
			case ExtensionsPackage.SIMPLE_OPERAND__TYPE:
				return type != null;
			case ExtensionsPackage.SIMPLE_OPERAND__VALUE_TYPE:
				return valueType != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (rawValue: ");
		result.append(rawValue);
		result.append(')');
		return result.toString();
	}
} //SimpleOperandImpl
