/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCAgentProxyImpl.java,v 1.26 2005/03/16 19:35:58 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Agent Proxy</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#getRuntimeId <em>Runtime Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#getStopTime <em>Stop Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#getCollectionMode <em>Collection Mode</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#isActive <em>Active</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#isAttached <em>Attached</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#isCollectionData <em>Collection Data</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#isMonitored <em>Monitored</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#getProfileFile <em>Profile File</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#getDeltaTime <em>Delta Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#getProcessProxy <em>Process Proxy</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#getConfigurations <em>Configurations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#getAgent <em>Agent</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl#getInternalCorrelations <em>Internal Correlations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCAgentProxyImpl extends EObjectImpl  implements TRCAgentProxy {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = "_unknown";

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getRuntimeId() <em>Runtime Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuntimeId()
	 * @generated
	 * @ordered
	 */
	protected static final String RUNTIME_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRuntimeId() <em>Runtime Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuntimeId()
	 * @generated
	 * @ordered
	 */
	protected String runtimeId = RUNTIME_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected static final double START_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected double startTime = START_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getStopTime() <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopTime()
	 * @generated
	 * @ordered
	 */
	protected static final double STOP_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStopTime() <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopTime()
	 * @generated
	 * @ordered
	 */
	protected double stopTime = STOP_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCollectionMode() <em>Collection Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectionMode()
	 * @generated
	 * @ordered
	 */
	protected static final TRCCollectionMode COLLECTION_MODE_EDEFAULT = TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;

	/**
	 * The cached value of the '{@link #getCollectionMode() <em>Collection Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectionMode()
	 * @generated
	 * @ordered
	 */
	protected TRCCollectionMode collectionMode = COLLECTION_MODE_EDEFAULT;

	/**
	 * The default value of the '{@link #isActive() <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isActive()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ACTIVE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isActive() <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isActive()
	 * @generated
	 * @ordered
	 */
	protected boolean active = ACTIVE_EDEFAULT;

	/**
	 * The default value of the '{@link #isAttached() <em>Attached</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAttached()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ATTACHED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAttached() <em>Attached</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAttached()
	 * @generated
	 * @ordered
	 */
	protected boolean attached = ATTACHED_EDEFAULT;

	/**
	 * The default value of the '{@link #isCollectionData() <em>Collection Data</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isCollectionData()
	 * @generated
	 * @ordered
	 */
	protected static final boolean COLLECTION_DATA_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isCollectionData() <em>Collection Data</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isCollectionData()
	 * @generated
	 * @ordered
	 */
	protected boolean collectionData = COLLECTION_DATA_EDEFAULT;

	/**
	 * The default value of the '{@link #isMonitored() <em>Monitored</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMonitored()
	 * @generated
	 * @ordered
	 */
	protected static final boolean MONITORED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isMonitored() <em>Monitored</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isMonitored()
	 * @generated
	 * @ordered
	 */
	protected boolean monitored = MONITORED_EDEFAULT;

	/**
	 * The default value of the '{@link #getProfileFile() <em>Profile File</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProfileFile()
	 * @generated
	 * @ordered
	 */
	protected static final String PROFILE_FILE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getProfileFile() <em>Profile File</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProfileFile()
	 * @generated
	 * @ordered
	 */
	protected String profileFile = PROFILE_FILE_EDEFAULT;

	/**
	 * The default value of the '{@link #getDeltaTime() <em>Delta Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeltaTime()
	 * @generated
	 * @ordered
	 */
	protected static final double DELTA_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getDeltaTime() <em>Delta Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeltaTime()
	 * @generated
	 * @ordered
	 */
	protected double deltaTime = DELTA_TIME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getConfigurations() <em>Configurations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfigurations()
	 * @generated
	 * @ordered
	 */
	protected EList configurations = null;

	/**
	 * The cached value of the '{@link #getAgent() <em>Agent</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAgent()
	 * @generated
	 * @ordered
	 */
	protected TRCAgent agent = null;

	/**
	 * The cached value of the '{@link #getInternalCorrelations() <em>Internal Correlations</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInternalCorrelations()
	 * @generated
	 * @ordered
	 */
	protected EList internalCorrelations = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCAgentProxyImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return HierarchyPackage.eINSTANCE.getTRCAgentProxy();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getRuntimeId() {
		return runtimeId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRuntimeId(String newRuntimeId) {
		String oldRuntimeId = runtimeId;
		runtimeId = newRuntimeId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__RUNTIME_ID, oldRuntimeId, runtimeId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStartTime() {
		return startTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartTime(double newStartTime) {
		double oldStartTime = startTime;
		startTime = newStartTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__START_TIME, oldStartTime, startTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getStopTime() {
		return stopTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStopTime(double newStopTime) {
		double oldStopTime = stopTime;
		stopTime = newStopTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__STOP_TIME, oldStopTime, stopTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCCollectionMode getCollectionMode() {
		return collectionMode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollectionMode(TRCCollectionMode newCollectionMode) {
		TRCCollectionMode oldCollectionMode = collectionMode;
		collectionMode = newCollectionMode == null ? COLLECTION_MODE_EDEFAULT : newCollectionMode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__COLLECTION_MODE, oldCollectionMode, collectionMode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setActive(boolean newActive) {
		boolean oldActive = active;
		active = newActive;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__ACTIVE, oldActive, active));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAttached() {
		return attached;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAttached(boolean newAttached) {
		boolean oldAttached = attached;
		attached = newAttached;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__ATTACHED, oldAttached, attached));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isCollectionData() {
		return collectionData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollectionData(boolean newCollectionData) {
		boolean oldCollectionData = collectionData;
		collectionData = newCollectionData;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__COLLECTION_DATA, oldCollectionData, collectionData));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isMonitored() {
		return monitored;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMonitored(boolean newMonitored) {
		boolean oldMonitored = monitored;
		monitored = newMonitored;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__MONITORED, oldMonitored, monitored));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getProfileFile() {
		return profileFile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProfileFile(String newProfileFile) {
		String oldProfileFile = profileFile;
		profileFile = newProfileFile;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__PROFILE_FILE, oldProfileFile, profileFile));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getDeltaTime() {
		return deltaTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeltaTime(double newDeltaTime) {
		double oldDeltaTime = deltaTime;
		deltaTime = newDeltaTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__DELTA_TIME, oldDeltaTime, deltaTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcessProxy getProcessProxy() {
		if (eContainerFeatureID != HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY) return null;
		return (TRCProcessProxy)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcessProxy(TRCProcessProxy newProcessProxy) {
		if (newProcessProxy != eContainer || (eContainerFeatureID != HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY && newProcessProxy != null)) {
			if (EcoreUtil.isAncestor(this, newProcessProxy))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newProcessProxy != null)
				msgs = ((InternalEObject)newProcessProxy).eInverseAdd(this, HierarchyPackage.TRC_PROCESS_PROXY__AGENT_PROXIES, TRCProcessProxy.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newProcessProxy, HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY, newProcessProxy, newProcessProxy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getConfigurations() {
		if (configurations == null) {
			configurations = new EObjectContainmentWithInverseEList(TRCConfiguration.class, this, HierarchyPackage.TRC_AGENT_PROXY__CONFIGURATIONS, HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY);
		}
		return configurations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public TRCAgent getAgent()
	{
		if (agent != null && agent.eIsProxy()) {
			TRCAgent oldAgent = agent;
//			((InternalEObject)agent).eSetProxyURI(URI.createPlatformResourceURI("platform:/resource/ProfileProject1/DefaultMonitor_slavescu_0_Tuesday,December2,2003121728PMEST-1070385448210_ApacheHTTPServerV1.3.20,V1.3.26,V2.0accesslogfiles__Cloudscape.trcadb"));
			agent = (TRCAgent)EcoreUtil.resolve(agent, this);
			if (agent != oldAgent) {
				//TODO: MS remove fix for DB resource
				if(agent.getAgentProxy()==null || agent.getAgentProxy()!=this) //MZ
					agent.setAgentProxy(this);
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, HierarchyPackage.TRC_AGENT_PROXY__AGENT, oldAgent, agent));
			}
		}
		return agent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAgent basicGetAgent() {
		return agent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAgent(TRCAgent newAgent, NotificationChain msgs) {
		TRCAgent oldAgent = agent;
		agent = newAgent;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__AGENT, oldAgent, newAgent);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAgent(TRCAgent newAgent) {
		if (newAgent != agent) {
			NotificationChain msgs = null;
			if (agent != null)
				msgs = ((InternalEObject)agent).eInverseRemove(this, HierarchyPackage.TRC_AGENT__AGENT_PROXY, TRCAgent.class, msgs);
			if (newAgent != null)
				msgs = ((InternalEObject)newAgent).eInverseAdd(this, HierarchyPackage.TRC_AGENT__AGENT_PROXY, TRCAgent.class, msgs);
			msgs = basicSetAgent(newAgent, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_AGENT_PROXY__AGENT, newAgent, newAgent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInternalCorrelations() {
		if (internalCorrelations == null) {
			internalCorrelations = new EObjectResolvingEList(CorrelationContainerProxy.class, this, HierarchyPackage.TRC_AGENT_PROXY__INTERNAL_CORRELATIONS);
		}
		return internalCorrelations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isToProfileFile()
	{
		if(profileFile!=null && profileFile.length()>0)
		{
			return true;
		}
		return false;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY, msgs);
				case HierarchyPackage.TRC_AGENT_PROXY__CONFIGURATIONS:
					return ((InternalEList)getConfigurations()).basicAdd(otherEnd, msgs);
				case HierarchyPackage.TRC_AGENT_PROXY__AGENT:
					if (agent != null)
						msgs = ((InternalEObject)agent).eInverseRemove(this, HierarchyPackage.TRC_AGENT__AGENT_PROXY, TRCAgent.class, msgs);
					return basicSetAgent((TRCAgent)otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY:
					return eBasicSetContainer(null, HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY, msgs);
				case HierarchyPackage.TRC_AGENT_PROXY__CONFIGURATIONS:
					return ((InternalEList)getConfigurations()).basicRemove(otherEnd, msgs);
				case HierarchyPackage.TRC_AGENT_PROXY__AGENT:
					return basicSetAgent(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY:
					return ((InternalEObject)eContainer).eInverseRemove(this, HierarchyPackage.TRC_PROCESS_PROXY__AGENT_PROXIES, TRCProcessProxy.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_AGENT_PROXY__NAME:
				return getName();
			case HierarchyPackage.TRC_AGENT_PROXY__TYPE:
				return getType();
			case HierarchyPackage.TRC_AGENT_PROXY__RUNTIME_ID:
				return getRuntimeId();
			case HierarchyPackage.TRC_AGENT_PROXY__START_TIME:
				return new Double(getStartTime());
			case HierarchyPackage.TRC_AGENT_PROXY__STOP_TIME:
				return new Double(getStopTime());
			case HierarchyPackage.TRC_AGENT_PROXY__COLLECTION_MODE:
				return getCollectionMode();
			case HierarchyPackage.TRC_AGENT_PROXY__ACTIVE:
				return isActive() ? Boolean.TRUE : Boolean.FALSE;
			case HierarchyPackage.TRC_AGENT_PROXY__ATTACHED:
				return isAttached() ? Boolean.TRUE : Boolean.FALSE;
			case HierarchyPackage.TRC_AGENT_PROXY__COLLECTION_DATA:
				return isCollectionData() ? Boolean.TRUE : Boolean.FALSE;
			case HierarchyPackage.TRC_AGENT_PROXY__MONITORED:
				return isMonitored() ? Boolean.TRUE : Boolean.FALSE;
			case HierarchyPackage.TRC_AGENT_PROXY__PROFILE_FILE:
				return getProfileFile();
			case HierarchyPackage.TRC_AGENT_PROXY__DELTA_TIME:
				return new Double(getDeltaTime());
			case HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY:
				return getProcessProxy();
			case HierarchyPackage.TRC_AGENT_PROXY__CONFIGURATIONS:
				return getConfigurations();
			case HierarchyPackage.TRC_AGENT_PROXY__AGENT:
				if (resolve) return getAgent();
				return basicGetAgent();
			case HierarchyPackage.TRC_AGENT_PROXY__INTERNAL_CORRELATIONS:
				return getInternalCorrelations();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_AGENT_PROXY__NAME:
				setName((String)newValue);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__TYPE:
				setType((String)newValue);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__RUNTIME_ID:
				setRuntimeId((String)newValue);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__START_TIME:
				setStartTime(((Double)newValue).doubleValue());
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__STOP_TIME:
				setStopTime(((Double)newValue).doubleValue());
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__COLLECTION_MODE:
				setCollectionMode((TRCCollectionMode)newValue);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__ACTIVE:
				setActive(((Boolean)newValue).booleanValue());
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__ATTACHED:
				setAttached(((Boolean)newValue).booleanValue());
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__COLLECTION_DATA:
				setCollectionData(((Boolean)newValue).booleanValue());
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__MONITORED:
				setMonitored(((Boolean)newValue).booleanValue());
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__PROFILE_FILE:
				setProfileFile((String)newValue);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__DELTA_TIME:
				setDeltaTime(((Double)newValue).doubleValue());
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY:
				setProcessProxy((TRCProcessProxy)newValue);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__CONFIGURATIONS:
				getConfigurations().clear();
				getConfigurations().addAll((Collection)newValue);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__AGENT:
				setAgent((TRCAgent)newValue);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__INTERNAL_CORRELATIONS:
				getInternalCorrelations().clear();
				getInternalCorrelations().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_AGENT_PROXY__NAME:
				setName(NAME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__RUNTIME_ID:
				setRuntimeId(RUNTIME_ID_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__START_TIME:
				setStartTime(START_TIME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__STOP_TIME:
				setStopTime(STOP_TIME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__COLLECTION_MODE:
				setCollectionMode(COLLECTION_MODE_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__ACTIVE:
				setActive(ACTIVE_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__ATTACHED:
				setAttached(ATTACHED_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__COLLECTION_DATA:
				setCollectionData(COLLECTION_DATA_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__MONITORED:
				setMonitored(MONITORED_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__PROFILE_FILE:
				setProfileFile(PROFILE_FILE_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__DELTA_TIME:
				setDeltaTime(DELTA_TIME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY:
				setProcessProxy((TRCProcessProxy)null);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__CONFIGURATIONS:
				getConfigurations().clear();
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__AGENT:
				setAgent((TRCAgent)null);
				return;
			case HierarchyPackage.TRC_AGENT_PROXY__INTERNAL_CORRELATIONS:
				getInternalCorrelations().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_AGENT_PROXY__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case HierarchyPackage.TRC_AGENT_PROXY__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case HierarchyPackage.TRC_AGENT_PROXY__RUNTIME_ID:
				return RUNTIME_ID_EDEFAULT == null ? runtimeId != null : !RUNTIME_ID_EDEFAULT.equals(runtimeId);
			case HierarchyPackage.TRC_AGENT_PROXY__START_TIME:
				return startTime != START_TIME_EDEFAULT;
			case HierarchyPackage.TRC_AGENT_PROXY__STOP_TIME:
				return stopTime != STOP_TIME_EDEFAULT;
			case HierarchyPackage.TRC_AGENT_PROXY__COLLECTION_MODE:
				return collectionMode != COLLECTION_MODE_EDEFAULT;
			case HierarchyPackage.TRC_AGENT_PROXY__ACTIVE:
				return active != ACTIVE_EDEFAULT;
			case HierarchyPackage.TRC_AGENT_PROXY__ATTACHED:
				return attached != ATTACHED_EDEFAULT;
			case HierarchyPackage.TRC_AGENT_PROXY__COLLECTION_DATA:
				return collectionData != COLLECTION_DATA_EDEFAULT;
			case HierarchyPackage.TRC_AGENT_PROXY__MONITORED:
				return monitored != MONITORED_EDEFAULT;
			case HierarchyPackage.TRC_AGENT_PROXY__PROFILE_FILE:
				return PROFILE_FILE_EDEFAULT == null ? profileFile != null : !PROFILE_FILE_EDEFAULT.equals(profileFile);
			case HierarchyPackage.TRC_AGENT_PROXY__DELTA_TIME:
				return deltaTime != DELTA_TIME_EDEFAULT;
			case HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY:
				return getProcessProxy() != null;
			case HierarchyPackage.TRC_AGENT_PROXY__CONFIGURATIONS:
				return configurations != null && !configurations.isEmpty();
			case HierarchyPackage.TRC_AGENT_PROXY__AGENT:
				return agent != null;
			case HierarchyPackage.TRC_AGENT_PROXY__INTERNAL_CORRELATIONS:
				return internalCorrelations != null && !internalCorrelations.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", type: ");
		result.append(type);
		result.append(", runtimeId: ");
		result.append(runtimeId);
		result.append(", startTime: ");
		result.append(startTime);
		result.append(", stopTime: ");
		result.append(stopTime);
		result.append(", collectionMode: ");
		result.append(collectionMode);
		result.append(", active: ");
		result.append(active);
		result.append(", attached: ");
		result.append(attached);
		result.append(", collectionData: ");
		result.append(collectionData);
		result.append(", monitored: ");
		result.append(monitored);
		result.append(", profileFile: ");
		result.append(profileFile);
		result.append(", deltaTime: ");
		result.append(deltaTime);
		result.append(')');
		return result.toString();
	}

} //TRCAgentProxyImpl
