/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HierarchyResourceSetImpl.java,v 1.9 2005/03/02 22:07:44 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;


/**
 * This class allows the definition of
 * <p>
 * 1. The singleton to be used by the clients<p>
 * 2. The <code>URIConverter</code> - it must use ZipWorkbenchURIConverter<p>
 * 3. The use of the <code>HierarchyResourceFactoryImpl</code> as the factory for the Agent resources.
 * This factory will handle the definition of keys to be used during the data load process.
 * 4. The Unresolved resource helper
 */
public class HierarchyResourceSetImpl extends ResourceSetImpl {
    //~ Static fields/initializers -----------------------------------------------------------------

    private static HierarchyResourceSetImpl instance;

    //~ Instance fields ----------------------------------------------------------------------------

    private IUnresolvedResourceHelper helper;

    //~ Constructors -------------------------------------------------------------------------------

    protected HierarchyResourceSetImpl() {
        super();
    }

    //~ Methods ------------------------------------------------------------------------------------

    public static HierarchyResourceSetImpl getInstance() {
        if (instance == null) {
            instance = new HierarchyResourceSetImpl();
            instance.setURIConverter(new HierarchyURIConverterImpl());

            //			Resource.Factory xmiResourceFactory = new XMIResourceFactoryImpl();
            Resource.Factory perftraceResourceFactory = new HierarchyResourceFactoryImpl();

            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcmxmi", perftraceResourceFactory);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcnxmi", perftraceResourceFactory);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcpxmi", perftraceResourceFactory);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcaxmi", perftraceResourceFactory);
			Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("corrxmi", perftraceResourceFactory);
			Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trclxmi", perftraceResourceFactory);
			Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trciovxmi", perftraceResourceFactory);
			Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcdbxmi", perftraceResourceFactory);
			
			Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcadb", new HyadesExtendedResourceFactory());
			Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("corrdb", new HyadesExtendedResourceFactory());
			Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("symptomdb", new HyadesExtendedResourceFactory());
		}

        return instance;
    }

    /**
     * If an object is not found with the given uri, load the
     * resource that has it.
     */
    public EObject getObjectAndLoad(URI uri) throws WrappedException {
        EObject obj = null;

        try {
            obj = super.getEObject(uri, true);
        } catch (WrappedException e) {
            if (helper != null) {
                helper.uriException(uri, (Exception) e);
            }

            throw e;
        }

        return obj;
    }

    public IUnresolvedResourceHelper getUnresolvedException() {
        return helper;
    }

    public void setUnresolvedResourceHelper(IUnresolvedResourceHelper helper) {
        this.helper = helper;
    }
}
