/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISDBLoader.java,v 1.7 2005/03/16 19:35:58 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * Parser for Symptom DB file
 */
public interface ISDBLoader {
    public String getErrorMessage();
    public void characters(char[] ch, int start, int length) throws SAXException;
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException;
    public void error(SAXParseException ex) ;
    public void fatalError(SAXParseException ex) throws SAXException ;
    public void loadDatabase(String xmlFileName, String destination, IProgressMonitor mon) throws Exception ;
	public void loadDatabase(InputStream is, String urlLocation, String destination, IProgressMonitor mon) throws Exception ;
    public void parse(String symptomDBFile) throws Exception;
    public void parse(InputStream is) throws Exception;
    public void startElement(String namespaceURI, String localName, String elementName, Attributes atts) throws SAXException;
    public void warning(SAXParseException ex);
    public String getExtension();
}
