/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id$
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import org.eclipse.core.runtime.Platform;

/**
 * @author slavescu
 */
public class ModelDebugger {
	public boolean debug = false;
	public boolean debugEventFlow = false;
	public boolean debugEventValue = false;
	public boolean debugEventsToFile = false;
	public boolean debugPerfUtil = false;

	protected String plugin_name; 
	protected String value; 

	public static ModelDebugger INSTANCE = new ModelDebugger("org.eclipse.hyades.models.hierarchy");

	public ModelDebugger(String plugin_name) {
		this.plugin_name = plugin_name;
		init();
	}

	protected void init() {
		try {
			value = Platform.getDebugOption(plugin_name+"/debug");
			if (value != null) {
				debug = value.equalsIgnoreCase("true");
			}
			value = Platform.getDebugOption(plugin_name+"/debug/eventsFlow");
			if (value != null) {
				debugEventFlow = value.equalsIgnoreCase("true");
			}
			value = Platform.getDebugOption(plugin_name+"/debug/eventsValue");
			if (value != null) {
				debugEventValue = value.equalsIgnoreCase("true");
			}
			value = Platform.getDebugOption(plugin_name+"/debug/eventsToFile");
			if (value != null) {
				debugEventsToFile = value.equalsIgnoreCase("true");
			}
			value = Platform.getDebugOption(plugin_name+"/debug/PerfUtil");
			if (value != null) {
				debugPerfUtil = value.equalsIgnoreCase("true");
			}
		} catch (Exception e) {
			// the platform is not available so it needs to be set directly
		}
	}
}