/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ServiceProxy.java,v 1.3 2005/06/17 15:11:05 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.automation.client;

import org.eclipse.hyades.automation.core.AbstractService;
import org.eclipse.hyades.automation.core.Service;

/**
 * The client-side service proxy allows the interrogation and execution of an
 * automatable service witout having first instantiated a real concrete on on
 * the server (within Eclipse)
 * 
 * @author Scott E. Schneider
 */
class ServiceProxy extends AbstractService {

    /**
     * Used by developers to assist in debugging, in this case, the execute
     * display additional information
     */
    private static final boolean DEBUG = false;

    /**
     * The automation client used for this service proxy
     */
    private final transient AutomationClient context;

    /**
     * The launch/execution strategy to use when launching and resolving the
     * command's intent
     */
    private final transient Service.Executable strategy;

    /**
     * Constructs a service proxy instance given the automation client to use,
     * the strategy to use and the identifier of the published service to
     * execute
     * 
     * @param context
     *            the automation client to use
     * @param strategy
     *            the strategy to use for launch and execution
     * @param identifier
     *            the identifier of the service to command/automate
     */
    ServiceProxy(AutomationClient context, Service.Executable strategy, String identifier) {
        super(identifier);
        this.context = context;
        this.strategy = strategy;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.hyades.automation.core.Service#execute()
     */
    public Object execute() {
        if (ServiceProxy.DEBUG) {
            System.out.println("Executing service " + this + " identified with " + this.getIdentifier());
            System.out.println("The strategy being used for execution is " + this.strategy);
            System.out.println("Context is " + this.context + " and configured properties are shown below");
            System.out.println(this.getProperties());
        }
        return this.strategy.execute(this);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.hyades.automation.core.Service#getRoot()
     */
    public String getRoot() {
        return this.context.getRoot();
    }

}