/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: TestExecution.java,v 1.2 2005/05/17 03:49:04 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.automation.tests;

import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.hyades.automation.client.adapters.java.JavaAdapter;

/**
 * The test execution test, a test case for exercising the execution of a test
 * 
 * @author Scott E. Schneider
 */
public class TestExecution extends TestCase {

    public static void main(String[] args) {
        junit.textui.TestRunner.run(TestExecution.class);
    }

    /**
     * Constructor for TestExecution.
     * 
     * @param name
     */
    public TestExecution(String name) {
        super(name);
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();

    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * Tests the execution of an automatable service such as the example service
     * using the given properties, this should use the default launch/execution
     * strategy to launch an instance of eclipse -- it will then execute the
     * automation server and command it in various ways such as execute
     */
    public void testExecute() {
        JavaAdapter automation = new JavaAdapter("c:\\eclipse-3.0.2\\eclipse");
        automation.execute("org.eclipse.hyades.execution.core.example", new Properties());
    }

}